<?php

class Youzify_Member_types {

    public $version;

    public function __construct() {

        // Init Data.
        $this->version = '1.0.0';

        // Load Functions.
        $this->init();

        // Default Options.
        add_filter( 'youzify_default_options', array( $this, 'default_options' ) );

        // Load Text Domain
        add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );

        // Load Xprofile Files.
        add_action( 'init', array( $this, 'init_xprofile_field_types' ) );

        // Fixes.
        add_action( 'bp_members_directory_member_types', array( $this, 'fixes' ), 1 );

        // Add Plugin Links.
        add_filter(
            'plugin_action_links_' . YOUZIFY_MT_BASENAME,
            array( $this, 'plugin_action_links' )
        );

        // Add Plugin Links in Multisite..
        add_filter(
            'network_admin_plugin_action_links_' . YOUZIFY_MT_BASENAME,
            array( $this, 'plugin_action_links' )
        );

    }

    /**
     * Fixes
     */
    function fixes() {
        // Remove Kleo Member Types
        remove_action( 'bp_members_directory_member_types', 'kleo_bp_member_types_tabs' );

    }

    /**
     * Init Files
     */
    private function init() {

        // Functions.
        require_once YOUZIFY_MT_PUBLIC . 'functions/youzify-member-types-functions.php';

        if ( defined( 'BP_PLATFORM_VERSION' ) && ! class_exists( 'BP_Admin_Types' ) ) {
            require YOUZIFY_MT_PUBLIC . 'buddyboss/core-taxonomy.php';
            require YOUZIFY_MT_PUBLIC . 'buddyboss/bp-admin-types.php';
            require YOUZIFY_MT_PUBLIC . 'buddyboss/bp-members-admin.php';
            require YOUZIFY_MT_PUBLIC . 'buddyboss/member-types-functions.php';
        }

    }

    /**
     * Include Xprofiles Classes
     */
    function init_xprofile_field_types() {

        if ( ! bp_is_active( 'xprofile' ) ) {
            return;
        }

        // XProfile Fields.
        require_once YOUZIFY_MT_PUBLIC . 'classes/youzify-xprofile-member-types-field.php';

    }

    /**
     * Default Options
     */
    function default_options( $options ) {

        // Options.
        $member_types_options = array(
            'youzify_member_type_multiple' => 'off',
            'youzify_allow_no_member_type' => 'off',
            'youzify_enable_member_types_in_infos' => 'on',
            'youzify_enable_member_types_modification' => 'on',
            'youzify_enable_member_types_registration' => 'on',
        );

        return array_merge( $options, $member_types_options );
    }

    /**
     * Text Domain
     */
    function load_textdomain() {
        load_plugin_textdomain( 'youzify-member-types', FALSE, dirname( YOUZIFY_MT_BASENAME ) . '/languages' );
    }

    /**
     * Action Links
     */
    function plugin_action_links( $links ) {
        // Get Plugin Pages.
        $panel_url = esc_url( add_query_arg( array( 'page' => 'youzify-extensions-settings&tab=member-types' ), admin_url( 'admin.php' ) ) );
        $plugin_url = 'https://www.youzify.com/downloads/buddypress-member-types/';
        $documentation_url = 'https://kainelabs.ticksy.com/articles/100012863';
        // Add a few links to the existing links array.
        return array_merge( $links, array(
            'settings' => '<a href="' . $panel_url . '">' . esc_html__( 'Settings', 'youzify-member-types' ) . '</a>',
            'documentation' => '<a href="' . $documentation_url . '">' . esc_html__( 'Documentation', 'youzify-member-types' ) . '</a>',
            'about'    => '<a href="' . $plugin_url . '">' . esc_html__( 'About',    'youzify-member-types' ) . '</a>'
        ) );
    }

}