document.addEventListener('DOMContentLoaded', function(event) {

    /*===================================================================
        SCIENCE CAFE FILTERS - ELEMENTS
    ===================================================================*/
    const filterButtons = document.querySelectorAll('.create_new_filter_data');
    const filterContainer = document.getElementById('filter_container');
    const eventsAccordion = document.querySelectorAll('.accordion.events-accordion > .accordion-item');
    const OPEN_LAST_ACCORDION_ITEM = true;

    if ( OPEN_LAST_ACCORDION_ITEM ) {
        if ( eventsAccordion ) {
            let lastAccordionItem = eventsAccordion.item(eventsAccordion.length -1);
            const title = lastAccordionItem.querySelector('.accordion-title');
            const inner = lastAccordionItem.querySelector('.accordion-inner');

            if ( ! title.classList.contains('active') ) title.classList.add('active');
            if ( title.hasAttribute('aria-expanded') ) title.setAttribute('aria-expanded', 'true');
            inner.style.display = 'block';
        }
    }

    /*===================================================================
        SCIENCE CAFE FILTERS - FUNCTIONS
    ===================================================================*/

    const get_filter_data = function () {
        let cart = [];
        const currentFilters = document.querySelectorAll('.filter_data');
        if ( currentFilters !== null ) {
            currentFilters.forEach((filter) => {
                cart.push(filter.innerText.trim());
            });
        }
        return cart;
    };

    const show_by_filter = function () {
        let cart = get_filter_data();

        if ( eventsAccordion && cart.length ) {
            jQuery(eventsAccordion).show(200);
            eventsAccordion.forEach((accordionItem) => {
                let found = 0;
                for (let x in cart) {
                    if ( accordionItem.classList.contains(cart[x]) ) {
                        found++;
                    }
                }
                if ( found > 0 ) {
                    accordionItem.style.display = 'block';
                }
                else {
                    accordionItem.style.display = 'none';
                }
            });
        }

    }

    const collapseAllAccordionItems = function () {
        if ( eventsAccordion ) {
            eventsAccordion.forEach((accordionItem) => {
                const title = accordionItem.querySelector('.accordion-title');
                const inner = accordionItem.querySelector('.accordion-inner');

                if ( title.classList.contains('active') ) title.classList.remove('active');
                if ( title.hasAttribute('aria-expanded') ) title.setAttribute('aria-expanded', 'false');
                inner.style.display = 'none';
            });
        }
    };

    const reloadEventsAccordion = function () {

        collapseAllAccordionItems();
        jQuery(eventsAccordion).hide();

        let cart = get_filter_data();
        if ( cart.length ) {
            show_by_filter();
            //console.log(cart);
        } else {
            jQuery(eventsAccordion).show(200);
        }
    };

    /*===================================================================
        SCIENCE CAFE FILTERS - EVENT LISTENERS
    ===================================================================*/

    if ( filterButtons !== null ) {
        filterButtons.forEach((filterButton) => {
            filterButton.addEventListener('click', function(e) {
                e.preventDefault();

                let filter_text = this.text.trim();
                let cart = get_filter_data();
                if ( cart.length ) {
                    for (let x in cart) {
                        if (cart[x] == filter_text) {
                          alert('selection filter has already been set');
                          return false;
                        }
                    }
                }

                if ( filterContainer ) {
                    filterContainer.innerHTML += '<span class="filter_btn"><span class="filter_data">' + filter_text + '</span> &nbsp;&nbsp;<span class="filter_data_close_btn">X</span></span>';
                }

                reloadEventsAccordion();
            });
        });
    }

    if ( filterContainer !== null ) {
        jQuery(filterContainer).on('click', '.filter_data_close_btn', {}, function (e) {
            let element = e.target.parentElement;
            if ( element ) {
                element.remove();
                reloadEventsAccordion();
            }
        });
    }

}, { capture: false, once: true });
