<?php if ( $wp_query->have_posts() ) : ?>

<h2 id="results-title">
    <span style="display: inline-block;" title="<?php printf( _n( 'Showing %s project of %s projects', 'Showing %s of %s projects', $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?> @ <?php echo __('page', 'erua') . ' ' . max( 1, $wp_query->query_vars['paged'] ) . ' ' . __('of', 'erua') . ' ' . max( 1, $wp_query->max_num_pages ); ?>"><?php echo __('There', 'erua') . ' ';  printf( _n( 'is %s project in', 'are %s projects in', $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->found_posts ) ); echo ' ' . $current_term_name . ' ' . __('category', 'erua'); ?></span>
</h2>

<ul class="projects-list">
<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
    <?php //do_action( 'flatsome_before_page_content' ); ?>

        <?php
        $aeiforia_project_category_terms = get_the_terms( get_the_ID(), $aeiforia_taxonomies['aeiforia-project-category']->name );
        $aeiforia_sustainability_pillar_terms = get_the_terms( get_the_ID(), $aeiforia_taxonomies['aeiforia-sustainability-pillar']->name );
        $aeiforia_erua_university_terms = get_the_terms( get_the_ID(), $aeiforia_taxonomies['aeiforia-erua-university']->name );
        $aeiforia_erua_region_terms = get_the_terms( get_the_ID(), $aeiforia_taxonomies['aeiforia-erua-region']->name );
        ?>

        <li class="project">
            <?php if ( has_post_thumbnail() ) : ?>
            <a href="<?php the_permalink(); ?>" title="<?php esc_attr(the_title()); ?>" class="project-image-link">
                <?php the_post_thumbnail('medium'); ?>
            </a>
            <?php endif; ?>
            <div class="project-inner">
                <?php $project_status = get_field('aeiforia_project_status'); ?>
                <span class="project-status <?php echo ( $project_status ) ? $project_status->slug : 'active' ?>"><?php echo ( $project_status ) ? $project_status->name : __('Active', 'erua'); ?></span>
                <div class="project-pillars">
                    <?php
                    if ( is_array($aeiforia_sustainability_pillar_terms) ) {
                        foreach ( $aeiforia_sustainability_pillar_terms as $key => $aeiforia_sustainability_pillar ) {
                            $separator = ( $key === array_key_last($aeiforia_sustainability_pillar_terms) ) ? '' : ', ';
    
                            echo '<span class="project-pillar"><a href="' . site_url('/') . $aeiforia_taxonomies['aeiforia-sustainability-pillar']->rewrite['slug'] . '/' . $aeiforia_sustainability_pillar->slug . '">'. $aeiforia_sustainability_pillar->name .'</a></span>' . $separator;
                        }
                    }
                    ?>
                </div>
                <?php if ( $project_acronym = get_field('aeiforia_project_acronym') ) : ?><h4 class="project-acronym"><?php echo $project_acronym; ?></h4><?php endif; ?>
                <span class="project-title"><a href="<?php echo get_permalink(); ?>"><i class="fa fa-file-text-o" aria-hidden="true"></i> <?php echo get_the_title(); ?></a></span>
                <div class="project-info">
                    <span><?php echo get_the_date() . ' by <a href="' . get_author_posts_url(get_the_author_meta( 'ID' )) . '">' . get_the_author() . '</a> <i class="fa fa-comments-o" aria-hidden="true"></i> ' . '<a href="'. esc_url( get_permalink() ) .'" title="' . get_comments_number( '0 comments', '1 comment', '% comments' ) .'" class="commentscount">'. get_comments_number( '0', '1', '%' ) .'</a>'; ?></span>
                </div>
                <a class="project-view-button" role="button" href="<?php the_permalink(); ?>"><?php _e('View the Project', 'erua'); ?></a>
                <div>
                    <?php if ( $aeiforia_project_category_terms[0]->term_id !== 23 || empty($aeiforia_erua_region_terms) ) : ?>
                    <p style="margin-bottom: 0;"><strong><?php _e('ERUA University/ies:', 'erua'); ?></strong></p>
                    <!-- <i class="fa fa-tags" aria-hidden="true"></i> -->
                    <?php
                    if ( is_array($aeiforia_erua_university_terms) ) {
                        foreach ( $aeiforia_erua_university_terms as $key => $aeiforia_erua_university ) {
                            $separator = ( $key === array_key_last($aeiforia_erua_university_terms) ) ? '' : ', ';
    
                            echo '<span class="project-topic"><a href="' . site_url('/') . $aeiforia_taxonomies['aeiforia-erua-university']->rewrite['slug'] . '/' . $aeiforia_erua_university->slug . '">'. $aeiforia_erua_university->name .'</a></span>' . $separator;
                        }
                    }
                    ?>
                    <?php else: ?>
                        <p style="margin-bottom: 0;"><strong><?php _e('ERUA Regions:', 'erua'); ?></strong></p>
                    <!-- <i class="fa fa-tags" aria-hidden="true"></i> -->
                    <?php
                    if ( is_array($aeiforia_erua_region_terms) ) {
                        foreach ( $aeiforia_erua_region_terms as $key => $aeiforia_erua_region ) {
                            $separator = ( $key === array_key_last($aeiforia_erua_region_terms) ) ? '' : ', ';
    
                            echo '<span class="project-topic"><a href="' . site_url('/') . $aeiforia_taxonomies['aeiforia-erua-region']->rewrite['slug'] . '/' . $aeiforia_erua_region->slug . '">'. $aeiforia_erua_region->name .'</a></span>' . $separator;
                        }
                    }
                    ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php //the_content(); ?>
        </li>

    <?php //do_action( 'flatsome_after_page_content' ); ?>
<?php endwhile; // end of the loop. ?>
</ul>

<div id="projects-pagination" class="pagination projects-pagination">
<?php
$big = 99999999999; // an unlikely big integer
// https://wordpress.stackexchange.com/questions/303297/paginate-link-generate-additional-038-whenever-my-url-have-multiple-query-stri
echo paginate_links( [
    //'base'            => str_replace( $big, '%#%', html_entity_decode( get_pagenum_link( $big ) ) ),
    'base'            => str_replace( [ $big, '&#038;' ], [ '%#%', '&' ], get_pagenum_link( $big ) ),
    //'base'            => str_replace( $big, '%#%', get_pagenum_link( $big, false ) ),
    'format'          => '/page/%#%', # '/page/%#%' or '?paged=%#%'
    'current'         => max( 1, $wp_query->query_vars['paged'] ),
    'total'           => $wp_query->max_num_pages,
    'prev_text'       => __( '<span class="meta-nav"><i class="fa-solid fa-chevron-left" aria-hidden="true"></i></span> Previous', 'erua' ),
    'next_text'       => __( 'Next <span class="meta-nav"><i class="fa-solid fa-chevron-right" aria-hidden="true"></i></span>', 'erua' ),
] );
?>
</div>

<?php
else :
echo '<p style="text-align: center; font-size: 2em; margin-top: 50px;">' . __('No projects found.', 'erua') . '</p>';
endif;

// Restore original post data.
wp_reset_postdata();
