<?php if ( $wp_query->have_posts() ) : ?>

<h2 id="results-title">
    <span style="display: inline-block;" title="<?php printf( _n( 'Showing %s presentation of %s presentations', 'Showing %s of %s presentations', $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?> @ <?php echo __('page', 'erua') . ' ' . max( 1, $wp_query->query_vars['paged'] ) . ' ' . __('of', 'erua') . ' ' . max( 1, $wp_query->max_num_pages ); ?>"><?php echo __('ShowRoom has', 'erua') . ' ';  printf( _n( '%s item', '%s items', $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->found_posts ) ); ?></span>
</h2>

<ul class="presentations-list">
<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
    <?php //do_action( 'flatsome_before_page_content' ); ?>

        <?php
        $showroom_category_terms = get_the_terms( get_the_ID(), $showroom_taxonomies['showroom-category']->name );
        //$showroom_tag_terms = get_the_terms( get_the_ID(), $showroom_taxonomies['showroom-tag']->name );

        // How can i put "posted x minutes ago on my posts?
        // https://wordpress.stackexchange.com/questions/36184/how-can-i-put-posted-x-minutes-ago-on-my-posts
        ?>

        <li class="presentation">
            <a class="presentation-link" href="<?php echo get_permalink(); ?>" title="<?php echo esc_attr(get_the_title()); ?>">
                <?php if ( has_post_thumbnail() ) : ?>
                <div class="presentation-image">
                <?php the_post_thumbnail('medium') ?>

                    <?php if ( $showroom_category_terms ) : ?>
                    <div class="presentation-category">
                        <?php if ( $cat_fa_icon = get_field('showroom_category_fa_icon', 'showroom-category_' . $showroom_category_terms[0]->term_id) ) : ?>
                            <i class="<?php echo $cat_fa_icon; ?>" aria-hidden="true"></i>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                <div class="presentation-inner">
                    <!-- <span class="presentation-engagement"><?php //echo ' <i class="fa fa-comments-o" aria-hidden="true"></i> ' . get_comments_number( '0', '1', '%' ); ?></span> -->
                    <span class="presentation-title"><?php echo get_the_title(); ?></span>
                    <span class="presentation-author"><?php echo 'By ' . get_the_author(); ?></span>
                    <span class="presentation-date"><?php echo get_the_date() . ' [ ' . __('Last updated on: ', 'erua') . get_the_modified_date( 'd/m/Y' ) . ' ]'; ?></span>
                </div>
            </a>
        </li>

    <?php //do_action( 'flatsome_after_page_content' ); ?>
<?php endwhile; // end of the loop. ?>
</ul>

<div id="presentations-pagination" class="pagination presentations-pagination">
<?php
$big = 99999999999; // an unlikely big integer
// https://wordpress.stackexchange.com/questions/303297/paginate-link-generate-additional-038-whenever-my-url-have-multiple-query-stri
echo paginate_links( [
    //'base'            => str_replace( $big, '%#%', html_entity_decode( get_pagenum_link( $big ) ) ),
    'base'            => str_replace( [ $big, '&#038;' ], [ '%#%', '&' ], get_pagenum_link( $big ) ),
    //'base'            => str_replace( $big, '%#%', get_pagenum_link( $big, false ) ),
    'format'          => '/page/%#%', # '/page/%#%' or '?paged=%#%'
    'current'         => max( 1, $wp_query->query_vars['paged'] ),
    'total'           => $wp_query->max_num_pages,
    'prev_text'       => __( '<span class="meta-nav"><i class="fa-solid fa-chevron-left" aria-hidden="true"></i></span> Previous', 'erua' ),
    'next_text'       => __( 'Next <span class="meta-nav"><i class="fa-solid fa-chevron-right" aria-hidden="true"></i></span>', 'erua' ),
] );
?>
</div>

<?php
else :
echo '<p style="text-align: center; font-size: 2em; margin-top: 50px;">' . __('No presentations found.', 'erua') . '</p>';
endif;

// Restore original post data.
wp_reset_postdata();
