<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// EVENT MANAGER PLUGIN - CUSTOM PLACEHOLDERS & CONDITIONALS
//================================================================================

/**
 * CUSTOM PLACEHOLDERS
 *
 * https://github.com/bippo/events-manager-wordpress/blob/master/classes/em-event.php
 * https://wp-events-plugin.com/tutorials/create-a-custom-placeholder-for-event-formatting/
 */
function my_em_styles_placeholders($replace, $EM_Event, $result) {

    switch ($result) {
        case '#_ACF_EVENT_REGISTER_LINK':
            if ( $event_register_link = get_field('event_register_link', $EM_Event->post_id) ) {

                $replace = '<a href="'.$event_register_link.'" rel="nofollow" target="_blank">'.$event_register_link.'</a>';
            }
            break;
        case '#_ACF_EVENT_READ_MORE_LINK':
            if ( $event_read_more_link = get_field('event_read_more_link', $EM_Event->post_id) ) {

                $replace = '<a href="'.$event_read_more_link.'" rel="nofollow" target="_blank">'.$event_read_more_link.'</a>';
            }
            break;
        case '#_EVENT_TIMEZONE': // Official placeholder is #_EVENTTIMEZONE
            if ( $event_timezone = get_post_meta($EM_Event->post_id, 'event_timezone', true) ) {

                $replace = $event_timezone;
            }
            else if ( $event_timezone = get_post_meta($EM_Event->post_id, '_event_timezone', true) ) {
    
                $replace = $event_timezone;
            }
            else {
                $replace = 'Europe/Athens';
            }
            break;
        case '#_ERUA_EVENT_RETURN_LINK':
            $event_categories = get_the_terms($EM_Event->post_id, 'event-categories');
            $replace = '';

            if ( $event_categories && count($event_categories) === 1 && 356 === $event_categories[0]->term_id ) {

                $replace = '<div style="text-align: left; margin-bottom: 40px;"><a href="../" class="red-hover"><i class="fa-solid fa-arrow-left" aria-hidden="true"></i> Back to calendar</a></div>';
            }
            break;
        case '#_ACF_EVENT_LOCATION_TYPE':
            if ( $event_location_type = get_field('event_location_type', $EM_Event->post_id) ) {

                $replace = $event_location_type;
                if ( $event_location_type === 'Hybrid' ) $replace .= ' ' . __('(Online &amp; On-site)', 'erua');
            }
            break;
        case '#_ACF_EVENT_LOCATION_ADDRESS':
            $event_location_type = get_field('event_location_type', $EM_Event->post_id);
            $replace = '';
            if ( !$event_location_type ) break;

            if ( ( $event_location_type === 'On-site' || $event_location_type === 'Hybrid' ) && $event_location_address = get_field('event_location_onsite_address', $EM_Event->post_id) ) {

                $replace = $event_location_address;
            }
            else if ( $event_location_type === 'Online' && $event_location_address = get_field('event_location_online_address', $EM_Event->post_id) ) {

                $replace = '<a href="'.$event_location_address.'" rel="nofollow" target="_blank">'.$event_location_address.'</a>';
            }
            break;
        case '#_ACF_EVENT_MAP_LOCATION':
            if ( $event_map_location = get_field('event_map_location', $EM_Event->post_id) ) {

                $replace = $event_map_location;
            }
            break;
        case '#_ACF_EVENT_ORGANIZER':
            if ( $event_organizer = get_field('event_organizer', $EM_Event->post_id) ) {

                $replace = $event_organizer;
            }
            break;
        case '#_ACF_EVENT_TYPE':
            if ( $event_type = get_field('event_type', $EM_Event->post_id) ) {

                $replace = $event_type;
            }
            break;
        case '#_ACF_EVENT_PROGRAMME_AGENDA':
            if ( $event_programme_agenda = get_field('event_programme_agenda', $EM_Event->post_id) ) {

                $replace = '<a href="'.$event_programme_agenda['url'].'" rel="nofollow" target="_blank">'.__('Download Programme of the Event', 'erua').'</a>';
            }
            break;
    }

    return $replace;
}
add_filter('em_event_output_placeholder', 'my_em_styles_placeholders', 1, 3);

/**
 * CUSTOM CONDITIONALS
 * 
 * https://wp-events-plugin.com/tutorials/creating-conditional-placeholders-for-events/
 */
function my_em_styles_event_output_show_condition($show, $condition, $full_match, $EM_Event) {
    if ( 'has_acf_event_register_link' === $condition && get_field('event_register_link', $EM_Event->post_id) ) {
        $show = true;
    }
    else if ( 'has_acf_event_read_more_link' === $condition && get_field('event_read_more_link', $EM_Event->post_id) ) {
        $show = true;
    }
    else if ( 'has_acf_event_location_type' === $condition && get_field('event_location_type', $EM_Event->post_id) ) {
        $show = true;
    }
    else if ( 'has_acf_event_location_address' === $condition && ( get_field('event_location_onsite_address', $EM_Event->post_id) || get_field('event_location_online_address', $EM_Event->post_id) ) ) {
        $show = true;
    }
    else if ( 'has_event_map_location' === $condition && get_field('event_map_location', $EM_Event->post_id) ) {
        $show = true;
    }
    else if ( 'has_acf_event_organizer' === $condition && get_field('event_organizer', $EM_Event->post_id) ) {
        $show = true;
    }
    else if ( 'has_acf_event_type' === $condition && get_field('event_type', $EM_Event->post_id) ) {
        $show = true;
    }
    else if ( 'has_acf_event_programme_agenda' === $condition && get_field('event_programme_agenda', $EM_Event->post_id) ) {
        $show = true;
    }
    return $show;
}
add_action('em_event_output_show_condition', 'my_em_styles_event_output_show_condition', 1, 4);

//================================================================================
// BACK-END FIELD HANDLING
//================================================================================

/**
 * If an Event has not been published before and has a draft status,
 * adjust its EM_Event timezone property.
 */
function event_post_update_timezone() {
    $screen = get_current_screen();

    if ( $screen->post_type=='event' && $screen->id=='event' ) {
        global $post;
        if ( $post->post_status === 'draft' ) {
            $date_created = get_field('field_634cb2932db85', $post->ID);
            $date_updated = get_field('field_634cb209de58d', $post->ID);
            /**
             * If these two dates match, then the event has never been saved/updated before,
             * and it has just been created.
             */
            if ( $date_created === $date_updated ) {
                $EM_Event = em_get_event($post->ID, 'post_id');
                $EM_Event->set_timezone(get_post_meta( $post->ID, 'event_timezone', true ));
                $EM_Event->save(); 
            }           
        }
        //echo "This is the Event edit post screen.";               
    }
}
add_action('in_admin_header', 'event_post_update_timezone');

/**
 * If a post of "event" type was updated,
 * then adjust the "date_updated" custom field.
 */
function event_post_update_modified_date($post_id, $post, $update)
{
    if ( $post->post_type == 'event' && $update ) {
        // If the "date_updated" custom field exists, update it.
        if ( get_field('field_634cb209de58d') ) {
            update_field('field_634cb209de58d', get_the_modified_time('j F Y, H:i', $post_id), $post_id);
        }
    }
    else if ( $post->post_type == 'event' && !$update ) {
        // If the "date_created" custom field value does not exist, initialiaze it.
        if ( !get_field('field_634cb2932db85') ) {
            update_field( 'field_634cb2932db85', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );
        }
        // If the "date_updated" custom field value does not exist, initialiaze it.
        if ( !get_field('field_634cb209de58d') ) {
            update_field( 'field_634cb209de58d', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );
        }
    }
}
add_action('save_post', 'event_post_update_modified_date', 10, 3);

function event_load_applicant_name( $value, $post_id, $field ) {

    $user_id = get_field('event_registered_user_id', $post_id);

    if ( !$user_id ) {
        return $value;
    }

    $user = get_user_by('id', (int) $user_id);

    if ( $value != $user->display_name ) {
        $value = $user->display_name;
    }

    return $value;
}
add_filter('acf/load_value/key=field_634cb1bc0c3f2', 'event_load_applicant_name', 10, 3); # Applicant's Name

function event_load_applicant_email( $value, $post_id, $field ) {

    $user_id = get_field('event_registered_user_id', $post_id);

    if ( !$user_id ) {
        return $value;
    }

    $user = get_user_by('id', (int) $user_id);

    if ( $value != $user->user_email ) {
        $value = $user->user_email;
    }

    return $value;
}
add_filter('acf/load_value/key=field_634cb16d0c3f1', 'event_load_applicant_email', 10, 3); # Applicant's E-mail

function event_load_applicant_profile_url( $value, $post_id, $field ) {

    if ( function_exists('bp_is_active') ) {

        $user_id = get_field('event_registered_user_id', $post_id);

        if ( !$user_id ) {
            return $value;
        }

        $user_profile_url = bbp_get_user_profile_url( (int) $user_id );

        if ( $value != $user_profile_url ) {
            $value = $user_profile_url;
        }
    }

    return $value;
}
add_filter('acf/load_value/key=field_657c427d48440', 'event_load_applicant_profile_url', 10, 3); # Applicant's Profile URL

function event_render_applicant_profile_url( $field ) {
    // echo '<pre>';
    // var_dump($field);
    // echo '</pre>';
    if ( $field['value'] ) {
        echo '<a href="'.$field['value'].'" target="_blank" style="display: inline-block; background-color: aliceblue; padding: 5px; border-radius: 0 0 5px 5px; text-decoration: none;">'.__('Visit profile', 'erua').'</a>';
    }
}
add_action( 'acf/render_field/key=field_657c427d48440', 'event_render_applicant_profile_url', 10, 1 );

//================================================================================
// DISABLING STUFF
//================================================================================

/**
 * Make an ACF field readonly to prevent editing.
 * https://www.advancedcustomfields.com/resources/acf-load_field/
 * https://support.advancedcustomfields.com/forums/topic/read-only-field-2/
 */
function event_acf_make_field_readonly( $field ) {

    // $field['choices'] = array(
    //     'custom' => 'My Custom Choice'
    // );
    //$field['disabled'] = 1;
    $field['readonly'] = true;

    return $field;

}
/**
 * Make an ACF field disabled to prevent editing.
 * https://www.advancedcustomfields.com/resources/acf-load_field/
 * https://github.com/AdvancedCustomFields/acf/issues/26
 */
function event_acf_make_field_disabled( $field ) {

    $field['disabled'] = true;

    return $field;

}
add_filter('acf/load_field/key=field_634cb1bc0c3f2', 'event_acf_make_field_readonly'); # Applicant's Name
add_filter('acf/load_field/key=field_634cb0d3f392e', 'event_acf_make_field_readonly'); # Applicant's User ID
add_filter('acf/load_field/key=field_634cb2932db85', 'event_acf_make_field_readonly'); # Date created
add_filter('acf/load_field/key=field_634cb209de58d', 'event_acf_make_field_readonly'); # Date updated
add_filter('acf/load_field/key=field_634ca9973e6d3', 'event_acf_make_field_readonly'); # Unique Token
if ( !current_user_can('administrator') ) {
    add_filter('acf/load_field/key=field_634cb16d0c3f1', 'event_acf_make_field_readonly'); # Applicant's E-mail
}

/**
 * Disable various fields at an Event's editing screen.
 */
function erua_disable_event_fields() {
    global $pagenow;

    // If we are at the back-office, at an Event post.
    if ( is_admin() && !( defined( 'DOING_AJAX' ) && DOING_AJAX ) && ($pagenow == 'post.php' || $pagenow == 'post-new.php') && get_post_type() == 'event' ) {
    ?>
        <script>
        jQuery(document).ready(function() {
            // Disable ACF's date picker at Event's editing screen.
            jQuery('#event-date-created .hasDatepicker').prop('disabled', 'disabled');
            jQuery('#event-date-updated .hasDatepicker').prop('disabled', 'disabled');

            jQuery("div[data-key='field_634cb2932db85']").css({position: "relative"});
            jQuery("div[data-key='field_634cb2932db85']").prepend('<div id="date-created-tracking-jammer" style="display:block; position:absolute; top:0; left:0; width:100%; height:100%; cursor: initial; z-index:9; background-color: aliceblue;"></div>');
            jQuery("div[data-key='field_634cb209de58d']").css({position: "relative"});
            jQuery("div[data-key='field_634cb209de58d']").prepend('<div id="date-updated-tracking-jammer" style="display:block; position:absolute; top:0; left:0; width:100%; height:100%; cursor: initial; z-index:9; background-color: aliceblue;"></div>');

            // Disable various Publishing actions
            jQuery('body.wp-admin #misc-publishing-actions .edit-timestamp').css({display: "none"});

            <?php //if ( is_user_logged_in() && !current_user_can('administrator') ) : ?>
            // Disable Title
            //jQuery('#title').prop('disabled', true);
            // Disable various Publishing actions
            jQuery('body.wp-admin #misc-publishing-actions #major-publishing-actions').css({display: "none"});

            // Hide Status Tracking
            jQuery("div[data-key='field_6468280506247']").css({position: "relative"});
            jQuery("div[data-key='field_6468280506247']").prepend('<div id="status-tracking-jammer" style="display:block; position:absolute; top:0; left:0; width:100%; height:100%; cursor: initial; z-index:9; background-color: aliceblue;"></div>');

            // Hide Unique ID
            jQuery("div[data-key='field_634ca9973e6d3']").css({position: "relative"});
            jQuery("div[data-key='field_634ca9973e6d3']").prepend('<div id="unique-id-jammer" style="display:block; position:absolute; top:0; left:0; width:100%; height:100%; cursor: initial; z-index:9; background-color: aliceblue;"></div>');

            <?php //endif; ?>
        });
        </script>
    <?php
    }

}
add_action('admin_print_footer_scripts', 'erua_disable_event_fields');

//================================================================================
// BUBBLE NOTIFICATIONS
//================================================================================

/**
 * Notification "bubble" with pending/open Events count
 */
add_action('admin_menu', function () {
    global $menu;
    //$count_posts = wp_count_posts('event');
    //$count = $count_posts->pending;

    // View all Events with an awaiting nature (pending, waiting for x's reply etc.) of status
    $events_query = get_posts(
        [
            'post_type' => 'event',
            'fields' => 'ids',
            //'post_status' => 'any', // Published, Pending etc.
            //'post_status' => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit', 'trash'],
            'post_status' => ['pending', 'draft'],
            'numberposts' => -1,
            // All Events that are not solved or closed i.e. pending or open
            // 'tax_query' => [
            //     [
            //         'taxonomy' => 'event-status',
            //         'field' => 'slug',
            //         'terms' => ['closed', 'solved'],
            //         'operator' => 'NOT IN',
            //     ],
            // ],
        ]
    );
    if (!empty($events_query)) wp_reset_postdata();
    $count = count($events_query);
    /* echo '<pre>';
    var_dump($events_query);
    echo '</pre>';
    die(); */

    $menu_item = wp_list_filter(
        $menu,
        [2 => 'edit.php?post_type=event'] // 2 is the position of an array item which contains URL, it will always be 2!
    );
    if ( !empty($menu_item) && $count > 0 ) {
        $menu_item_position = key($menu_item); // get the array key (position) of the element
        $menu[$menu_item_position][0] .= ' <span class="awaiting-mod" title="' . $count . ' Events require actions">' . $count . '</span>';
    }
});
