<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// FORM SHORTCODE DEFINITION
//================================================================================

/**
 * This function contains all the code needed 
 * to render the ACF form for submitting events, 
 * in the form of a WordPress shortcode.
 */
function events_form_shortcode( $atts ) {

    extract( shortcode_atts( array(), $atts ) );
    $output = '';

    ob_start();

    // Show the form only to logged-in users
    if (is_user_logged_in()) {

        // https://www.advancedcustomfields.com/resources/acf_register_form/
        $settings = array(

            /* (string) Unique identifier for the form. Defaults to 'acf-form' */
            'id' => 'events-form',

            /* (int|string) The post ID to load data from and save data to. Defaults to the current post ID.
            Can also be set to 'new_post' to create a new post on submit */
            //'post_id'		=> "user_" . $current_user->ID,
            'post_id'		=> 'new_post',

            /* (array) An array of post data used to create a post. See wp_insert_post for available parameters.
	        The above 'post_id' setting must contain a value of 'new_post' */
            // 'new_post'	=> array(
            //     'post_type'		=> 'request',
            //     'post_status'	=> 'publish'
            // ),

            /* (array) An array of field group IDs/keys to override the fields displayed in this form */
            //'field_groups' => array('group_5a16ce3c67cb6', 'group_59f6eb9e7c014'),
            'field_groups' => array('group_63492214b049e'),

            /* (array) An array of field IDs/keys to override the fields displayed in this form */
	        //'fields' => false,

            /* (boolean) Whether or not to show the post title text field. Defaults to false */
            'post_title' => false,

            /* (boolean) Whether or not to show the post content editor field. Defaults to false */
            'post_content' => false,

            /* (boolean) Whether or not to create a form element. Useful when a adding to an existing form. Defaults to true */
            'form' => true,
                                                
            /* (string) The URL to be redirected to after the form is submit. Defaults to the current URL with a GET parameter '?updated=true'.
            A special placeholder '%post_url%' will be converted to post's permalink (handy if creating a new post)
            A special placeholder '%post_id%' will be converted to post's ID (handy if creating a new post) */
            //'return' => '?updated=true#library-form-heading',
            'return'	=> site_url('event-submitted'), // Redirect to a thank you page
            //'return' => add_query_arg( 'updated', 'true', get_permalink() )

            /* (string) Extra HTML to add before the fields */
            //'html_before_fields' => '',

            /* (string) Extra HTML to add after the fields */
			'html_after_fields'  => '',
            //'html_after_fields'  => '<input type="hidden" id="event-categories-input" name="event-categories" value="' . implode(",", $event_categories) . '" />',

            /* (string) The text displayed on the submit button */
            'submit_value' => __('Submit', 'erua'),

            /* (string) A message displayed above the form after being redirected. Can also be set to false for no message */
            'updated_message' => __('Your event has been submitted!', 'erua'),

            /* (string) Determines where field labels are places in relation to fields. Defaults to 'top'.
            Choices of 'top' (Above fields) or 'left' (Beside fields) */
            'label_placement' => 'top',

            /* (string) Determines where field instructions are places in relation to fields. Defaults to 'label'.
            Choices of 'label' (Below labels) or 'field' (Below fields) */
            'instruction_placement' => 'label',

            /* (string) Determines element used to wrap a field. Defaults to 'div'
            Choices of 'div', 'tr', 'td', 'ul', 'ol', 'dl' */
            'field_el' => 'div',

            /* (string) Whether to use the WP uploader or a basic input for image and file fields. Defaults to 'wp'
            Choices of 'wp' or 'basic'. Added in v5.2.4 */
            'uploader' => 'wp'

            /* (boolean) Whether to include a hidden input field to capture non human form submission. Defaults to true. Added in v5.3.4 */
            //'honeypot' => true,

            /* (string) HTML used to render the updated message. Added in v5.5.10 */
            //'html_updated_message'	=> '<div id="message" class="updated"><p>%s</p></div>',

            /* (string) HTML used to render the submit button. Added in v5.5.10 */
            //'html_submit_button'	=> '<input type="submit" class="acf-button button button-primary button-large" value="%s" />',

            /* (string) HTML used to render the submit button loading spinner. Added in v5.5.10 */
            //'html_submit_spinner'	=> '<span class="acf-spinner"></span>',

            /* (boolean) Whether or not to sanitize all $_POST data with the wp_kses_post() function. Defaults to true. Added in v5.6.5 */
            //'kses'	=> true
        );

        acf_form($settings);

        require_once get_stylesheet_directory() . '/includes/news-events/events/form-scripts.php';
    }
    else {
        $login_url = site_url() . '/login/'; # get_permalink( get_option('woocommerce_myaccount_page_id') );
        echo '<a href="' . $login_url . '" id="logreg">Login or register to submit an event</a>';
    }

    $output = ob_get_contents();
    ob_end_clean();

    return $output;
}
add_shortcode('events-form', 'events_form_shortcode');

//================================================================================
// FORM PROCESSING
//================================================================================

/**
 * Using a hook to act before an ACF form is saved,
 * we will cancel saving if conditions for a new post are not met, 
 * and if they are, we'll then get the POST data 
 * and insert it into the new post.
 */
function events_acf_form_pre_save_post( $post_id ) {

	// Stop function and bail early if not a new post
	if ( $post_id !== 'new_post' ) {
		return $post_id;
    }

    // echo '<pre>';
    // var_dump($_POST);
    // echo '</pre>';
    // die();

    if ( isset($_POST['acf']['field_634ae3be6dc3b']) && $_POST['acf']['field_634ae3be6dc3b'] === 'event' ) {

        // if ( !is_user_logged_in() ) {
        //     return $post_id;
        // }

        // echo '<pre>';
        // var_dump($_POST);
        // echo '</pre>';
        // die();

        // global $wp_query;
        // echo '<pre>';
        // var_dump($wp_query);
        // echo '</pre>';
        // die();

        //global $wp_roles;
        //$roles = $wp_roles->get_names();
        // Below code will print the list of all roles.
        //print_r($roles);

        // if (isset($_POST["preview-mode"])) {
        // 	get_template_part( '/template-parts/profile', 'preview' );
        // 	// Prevent the form from saving
        // 	die();
        // }
        // else {
        // 	// Save the post
        // 	do_action('acf/save_post' , $post_id);
        // }

        // Get the POST data
        if ( 
            isset($_POST['acf']['field_6349251aa82f9']) && 
            isset($_POST['acf']['field_63492ab0ebb47']) &&  
            isset($_POST['acf']['field_634ae7be7c006']) && 
            isset($_POST['acf']['field_634b63c405f99']) && 
            isset($_POST['acf']['field_634b651c84bd4']) && 
            isset($_POST['acf']['field_65a9330519c44'])
        ) {
            $event_title = wp_strip_all_tags( trim( $_POST['acf']['field_6349251aa82f9'] ) );
            $event_description = trim( $_POST['acf']['field_63492ab0ebb47'] );
            $event_date = wp_strip_all_tags( trim( $_POST['acf']['field_634ae7be7c006'] ) );
            $event_time = wp_strip_all_tags( trim( $_POST['acf']['field_634b63c405f99'] ) );
            $event_location_type = $_POST['acf']['field_634b651c84bd4'];
            $event_tzone = wp_strip_all_tags( trim( $_POST['acf']['field_65a9330519c44'] ) );
        }
        // If any crucial POST data is missing then abort
        else {
            return $post_id;
        }

        // If the user is a guest and has not set his name or e-mail, then abort.
        if ( !is_user_logged_in() && (!isset($_POST['acf']['field_6349242b3cdff']) || !isset($_POST['acf']['field_634924773ce00'])) ) {
            return $post_id;
        }

        // echo '<pre>';
        // var_dump($_POST);
        // echo '</pre>';
        // die();

        // https://codex.wordpress.org/wp_get_current_user
        $current_user = wp_get_current_user();

        //$title = $questioner_name . ' (' . $questioner_email . ')';

        // Get "ERUA Event" category
        $event_category_term = get_term_by('id', 356, 'event-categories');
        // $showroom_event_category_slug = $event_category_term->slug;
        $event_category = (int) $event_category_term->term_id;

        /**
         * Create a new post
         * https://developer.wordpress.org/reference/functions/wp_insert_post/#parameters
         * https://wordpress.stackexchange.com/questions/78543/wp-insert-post-or-wp-set-post-terms-do-not-save-taxonomy-but-wp-set-post-terms
         * https://wordpress.org/support/topic/polylangcount-posts-using-get_term_by/
         */
        $post = array(
            'post_status'	=> 'draft',
            'post_type'		=> 'event',
            'post_title'	=> $event_title,
            'post_author'	=> $current_user->ID,
            //'comment_status' => 'closed',
            // https://wordpress.org/support/topic/events-manager-with-gutenberg/
            'post_content'  => $event_description, # https://wp-events-plugin.com/blog/2018/12/06/wordpress-5-0-and-gutenberg-compatibility/
            // for core categories taxonomy only
            //'post_category' => array($category),
            // for custom taxonomies
            // 'tax_input'     => [
            //     'event-categories' => [ intval( $event_category ) ],
            // ],
        );

        // Insert the post
        $post_id = wp_insert_post( $post );

        // Make it Private (private posts don't appear in the taxonomy term count!)
        //wp_update_post( array( 'ID' => $post_id, 'post_status' => 'private' ));

        /* var_dump($status_term);
        echo '<br><br>' . $status;
        echo '<span>' . $status_term->name . ' / '. $status_term->count . '</span>';
        die(); */

        /**
         * Since non logged-in users cannot use tax_input, 
         * we are setting the status and taxonomies AFTER the post's creation.
         */
        //if ( !is_user_logged_in() ) {
            $term_taxonomy_ids = wp_set_object_terms( $post_id, [ intval( $event_category ) ], 'event-categories' );
        //}

        // Set its default status to "Open"
        //$term_taxonomy_ids = wp_set_object_terms( $post_id, array( intval( $status ) ), 'event-status' );
        //wp_set_post_terms( $post_id, array( (int) $status ), 'event-status' );
        //$terms_updated = wp_update_term_count_now( $status_term->term_taxonomy_id, 'event-status');

        /* var_dump($terms_updated);
        die(); */

        /* if ( is_wp_error( $term_taxonomy_ids ) ) {
            // There was an error somewhere and the terms couldn't be set.
            die();
        } else {
            // Success! These categories were added to the post.
        } */

        /**
         * Insert date created
         * https://developer.wordpress.org/reference/functions/get_post_time/
         */
        update_field( 'field_634cb2932db85', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );

        /**
         * Insert date updated
         */
        update_field( 'field_634cb209de58d', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );

        /**
         * Insert author/applicant
         */
        if ( is_user_logged_in() ) {
            update_field( 'field_634cb1bc0c3f2', $current_user->display_name, $post_id );
            update_field( 'field_634cb0d3f392e', $current_user->ID, $post_id );
        }
        else if ( isset($_POST['acf']['field_6349242b3cdff']) ) {
            update_field( 'field_634cb1bc0c3f2', $_POST['acf']['field_6349242b3cdff'], $post_id );
        }

        /**
         * Insert author/applicant's e-mail
         */
        if ( is_user_logged_in() ) {
            update_field( 'field_634cb16d0c3f1', $current_user->user_email, $post_id );
        }
        else if ( isset($_POST['acf']['field_634924773ce00']) ) {
            update_field( 'field_634cb16d0c3f1', $_POST['acf']['field_634924773ce00'], $post_id );
        }

        /**
         * Insert Applicant's Profile URL
         */
        if ( is_user_logged_in() && function_exists('bp_is_active') ) {
            update_field( 'field_657c427d48440', bbp_get_user_profile_url( (int) $current_user->ID ), $post_id );
        }

        //$timezone = new DateTimeZone($event_tzone);
        //$event_date_obj = date_create($event_date, $timezone);
        $event_date_obj = date_create($event_date);
        $event_date_end_obj = null;
        $diff = 0;

        if ( isset($_POST['acf']['field_641734aa58f79']) ) {
            $event_date_end_obj = date_create( wp_strip_all_tags( trim( $_POST['acf']['field_641734aa58f79'] ) ) );
            // https://stackoverflow.com/a/29099815
            $diff_obj = date_diff( $event_date_obj, $event_date_end_obj );
            $diff = (int) $diff_obj->format("%R%a");
        }

        // Insert Event Date
        if ( $event_date_obj ) {
            $event_date_obj = date_format($event_date_obj,"Y-m-d"); # e.g. 20221026 to 2022-10-26

            if ( $event_date_end_obj && $diff > 0 ) {
                $event_date_end_obj = date_format($event_date_end_obj,"Y-m-d");

                update_post_meta( $post_id, '_event_start_date', $event_date_obj );
                update_post_meta( $post_id, '_event_start', $event_date_obj . ' ' . $event_time );
                update_post_meta( $post_id, '_event_start_local', $event_date_obj . ' ' . $event_time );
                update_post_meta( $post_id, '_event_end_date', $event_date_end_obj );
                update_post_meta( $post_id, '_event_end', $event_date_end_obj . ' ' . $event_time );
                update_post_meta( $post_id, '_event_end_local', $event_date_end_obj . ' ' . $event_time );
            }
            else {
                update_post_meta( $post_id, '_event_start_date', $event_date_obj );
                update_post_meta( $post_id, '_event_start', $event_date_obj . ' ' . $event_time );
                update_post_meta( $post_id, '_event_start_local', $event_date_obj . ' ' . $event_time );
                update_post_meta( $post_id, '_event_end_date', $event_date_obj );
                update_post_meta( $post_id, '_event_end', $event_date_obj . ' ' . $event_time );
                update_post_meta( $post_id, '_event_end_local', $event_date_obj . ' ' . $event_time );
            }
        }
        else {
            update_post_meta( $post_id, '_event_start_date', '1970-10-10' );
            update_post_meta( $post_id, '_event_start', '1970-10-10' . ' ' . $event_time );
            update_post_meta( $post_id, '_event_start_local', '1970-10-10' . ' ' . $event_time );
            update_post_meta( $post_id, '_event_end_date', '1970-10-10' );
            update_post_meta( $post_id, '_event_end', '1970-10-10' . ' ' . $event_time );
            update_post_meta( $post_id, '_event_end_local', '1970-10-10' . ' ' . $event_time );
        }

        // Insert an Event ID
        //update_post_meta( $post_id, '_event_id', $post_id );

        // Insert Location Type
        update_post_meta( $post_id, '_event_location_type', null );

        // Insert Event Time (e.g. 18:00:00)
        update_post_meta( $post_id, '_event_start_time', $event_time );
        update_post_meta( $post_id, '_event_end_time', $event_time );

        /**
         * Insert Event Timezone
         * https://wp-events-plugin.com/documentation/timezone-support/
         * https://www.damiencarbery.com/2017/10/create-events-manager-events-programmatically/
         * https://hotexamples.com/examples/-/-/em_get_event/php-em_get_event-function-examples.html
         * https://wordpress.org/support/topic/how-to-change-a-specific-events-timezone-programmatically/
         */
        //update_post_meta( $post_id, 'event_timezone', 'UTC' );
        //update_post_meta( $post_id, '_event_timezone', 'UTC' );
        update_post_meta( $post_id, '_event_timezone', $event_tzone );
        update_post_meta( $post_id, 'event_timezone', $event_tzone );
        // if ( function_exists('em_get_event') ) {
        //     $EM_Event = em_get_event($post_id, 'post_id');
        //     $EM_Event->set_timezone('UTC');
        //     $EM_Event->save();
        // }

        // Insert Event Type
        update_field( 'field_634cb08885492', $event_location_type, $post_id );
        // Insert Event Link
        if ( isset($_POST['acf']['field_634ae59a985b3']) ) {
            update_field( 'field_634caa53acc94', $_POST['acf']['field_634ae59a985b3'], $post_id );
        }
        // Insert Event Photo
        if ( isset($_POST['acf']['field_634ae4a85cff5']) ) {
            update_field( 'field_634cadb1acc95', $_POST['acf']['field_634ae4a85cff5'], $post_id );
        }

        /**
         * Create a unique_token for the post.
         * (1) Concatenate some data - the post's ID, the date and a random number for entropy.
         * (2) Hash the above data with SHA256, that way always producing a 64 characters string.
         * (3) Encode the produced hash into a base64 string and remove the padding, which will always be 
         *     a double "=" (i.e. two characters) since we are always encoding strings of a known, constant length.
         */
        $data_to_hash = $post_id . get_the_date('c', $post_id) . uniqid(rand(), TRUE);
        $unique_token = substr(base64_encode(hash('sha256', $data_to_hash, false)), 0, -2);
        update_field( 'field_634ca9973e6d3', $unique_token, $post_id );

        //wp_update_post( ['ID' => $post_id] );

        // Send e-mail notifications
        //send_emails_after_event_creation($post_id);
    }

    // Return the new ID
    return $post_id;

}
add_filter('acf/pre_save_post', 'events_acf_form_pre_save_post', 1, 1);

/**
 * Hooking into 'acf/save_post' with a high priority such as 20,
 * ensures that the $_POST data have already been saved,
 * and therefore we can get/access all custom fields of the post.
 * Alternatively we may use a priority lower than 10,
 * to manipulate the data before it gets saved.
 * 
 * https://www.advancedcustomfields.com/resources/acf-save_post/
 */
function events_acf_form_after_save_post( $post_id ) {

    if ( get_post_type($post_id) !== 'event' ) {
        return;
    }

    $date_created = get_field('field_634cb2932db85', $post_id);
    $date_updated = get_field('field_634cb209de58d', $post_id);

    /**
     * If these two dates match, then the document has never been saved/updated before
     * (because we refresh the $date_updated on each save using the 'save_post' hook),
     * and it has just been created.
     */
    if ( $date_created === $date_updated ) {

        global $DEFAULT_IMAGE;

        $event_featured_image = get_field( 'field_634cadb1acc95', $post_id );
        $event_programme_agenda = get_field( 'field_65aafc12b3391', $post_id );

        global $FILEBIRD_EVENTS_FOLDER;

        // If an Event Photo was uploaded to the post
        if ( $event_featured_image  ) {

            $destination_filebird_folder = $FILEBIRD_EVENTS_FOLDER; # 'Events'
            $attachment_id = $event_featured_image['ID'];

            // Move the attachment to the appropriate FileBird folder.
            if ( $attachment_id !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
                move_attachment_to_filebird_folder( $attachment_id, $destination_filebird_folder );
            }

        }

        // If an Event Programme Agenda was uploaded to the post
        if ( $event_programme_agenda  ) {

            $destination_filebird_folder = $FILEBIRD_EVENTS_FOLDER; # 'Events'
            $attachment_id = $event_programme_agenda['ID'];

            // Move the attachment to the appropriate FileBird folder.
            if ( $attachment_id !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
                move_attachment_to_filebird_folder( $attachment_id, $destination_filebird_folder );
            }

        }

    }

    //$terms = get_the_terms($post_id, 'event-status');
    //$current_status = $terms[0]->slug;
    // https://developer.wordpress.org/reference/functions/get_post_status/#comment-4839
    $current_status = get_post_status($post_id);
    $previous_status = get_post_meta($post_id, 'event_status_tracking', true);

    // Don't send new email if the status didn't change!
    if ( $current_status === $previous_status ) {
        return;
    }

    if ( $current_status === 'publish' ) {
        //send_emails_on_event_approval($post_id);
    }
    update_field( 'field_6468280506247', $current_status, $post_id );
}
add_action('acf/save_post', 'events_acf_form_after_save_post', 20);

//================================================================================
// FIELD HANDLING - WYSIWYG
//================================================================================

/**
 * Prepare the wysiwyg to have a character limit.
 * https://support.advancedcustomfields.com/forums/topic/set-max-length-for-editor/
 * https://www.advancedcustomfields.com/resources/acf-validate_value/
 * https://www.lettercount.com/
 */
function events_acf_form_validate_wysiwyg_field( $valid, $value, $field, $input ) {

    // echo '<pre>';
    // print_r($field);
    // echo '</pre>';
    // die();

    // bail early if value is already invalid
    if( !$valid ) {

        return $valid;

    }

    //$message_length = mb_strlen( htmlspecialchars_decode(strip_tags($value)) );
    $message_length = mb_strlen( htmlspecialchars_decode(strip_tags($value)), 'utf8' );
    //$message_length = strlen( htmlspecialchars_decode(strip_tags($value)));
    //$message_length = strlen( htmlspecialchars_decode(strip_tags(utf8_decode( $value ))) );

    if ( $message_length > 5000 ) {

        //$valid = __( "Your message is $message_length characters long. You can't enter more than 5000 characters.", 'erua' ) . ' ' . htmlspecialchars_decode(strip_tags($value));
        $valid = __( "Your message contains $message_length characters. The limit is at 5000 characters.", 'erua' );

    }
    
    // return
    return $valid;

}
add_filter('acf/validate_value/key=field_63492ab0ebb47', 'events_acf_form_validate_wysiwyg_field', 10, 4);

//================================================================================
// FIELD HANDLING
//================================================================================

/**
 * Make sure that for multi-day Events,
 * the Event Date is earlier than the Event's End Date.
 *
 * https://support.advancedcustomfields.com/forums/topic/validation-of-a-field-based-on-the-value-of-another-field/
 */
function events_acf_form_validate_date_end_field( $valid, $value, $field, $input ) {

    // bail early if value is already invalid
    if( !$valid || !isset($_POST['acf']['field_634ae7be7c006']) ) {

        return $valid;

    }

    $event_date = date_create($_POST['acf']['field_634ae7be7c006']);
    $event_date_end = date_create($value);

    if ( $event_date === false || $event_date_end === false ) return $valid;

    // https://stackoverflow.com/a/29099815
    $diff_obj = date_diff( $event_date, $event_date_end );
    $diff = (int) $diff_obj->format("%R%a");

    if ( $diff < 0 ) {
        $valid = __( "Your Event's end date shouldn't be earlier than the start date.", 'erua' );
    }

    // return
    return $valid;
}
add_filter('acf/validate_value/key=field_641734aa58f79', 'events_acf_form_validate_date_end_field', 10, 4);

/**
 * Make sure that the Event Starting Time is in the correct format.
 */
function events_acf_form_validate_time_field( $valid, $value, $field, $input ) {

    // bail early if value is already invalid
    if( !$valid || !isset($_POST['acf']['field_634b63c405f99']) ) {

        return $valid;

    }

    $event_time = wp_strip_all_tags( trim( $_POST['acf']['field_634b63c405f99'] ) );

    if ( !isValidDate($event_time, 'H:i:s') ) {//21:14:00
        $valid = __( "Your Event's time has a wrong format. Use the time picker to properly format it.", 'erua' );
    }

    // return
    return $valid;
}
add_filter('acf/validate_value/key=field_634b63c405f99', 'events_acf_form_validate_time_field', 10, 4);

/**
 * Hide or show form fields depending on 
 * whether the user is logged-in or a guest.
 * https://www.advancedcustomfields.com/resources/acf-prepare_field/
 * https://www.advancedcustomfields.com/resources/get_field_object/
 */
function events_acf_form_prepare_guest_field( $field ) {

	// if( $field['value'] ) {
	// 	$field['disabled'] = true;	
    // }
    // $field['value'] = 'hmm';

    // We only want to show the field to guests, and hide it from logged-in users!
    if ( is_user_logged_in() ) {
        return false;
    }
    else {
        return $field;
    }

}
add_filter('acf/prepare_field/key=field_6349242b3cdff', 'events_acf_form_prepare_guest_field'); // Applicant's Name
add_filter('acf/prepare_field/key=field_634924773ce00', 'events_acf_form_prepare_guest_field'); // Applicant's E-mail

//================================================================================
// FIELD HANDLING - FORM IDENTIFIER
//================================================================================

/**
 * Detect any change in the default value of the form identifier.
 */
function events_acf_form_validate_identifier( $valid, $value, $field, $input ) {
    // bail early if value is already invalid
    if ( !$valid ) {
        return $valid;
    }

    if ( $value !== $field['default_value'] ) {
        $valid = __( 'Incorrect form action', 'erua' );
    }

    return $valid;
}
add_filter('acf/validate_value/key=field_634ae3be6dc3b', 'events_acf_form_validate_identifier', 10, 4);



/**
 * https://wp-events-plugin.com/documentation/shortcodes/
 * https://eventsmanager.site/shortcode/
 * https://eventsmanager.site/events/
 * https://wordpress.org/support/topic/events-not-showing-in-the-calendar-2/
 * https://wordpress.org/support/topic/full-calendar-replaced-by-small-calendar/#post-17111926
 * 
 * https://wp-events-plugin.com/documentation/event-search-attributes/
 * https://wordpress.org/support/topic/display-event-search-bar-when-using-shortcode/
 * [events_calendar category="381" long_events=1 full=1 show_search=1 has_search=1 view=list views=calendar,list,grid,list-grouped scope="future"]
 */

//echo do_shortcode('[events_calendar full="1" long_events="1" calendar_size="large"]');
//echo do_shortcode('[events_calendar full="1" long_events="1" has_search="1" show_search="1" pagination="1" calendar_size="large"]');

// https://wp-events-plugin.com/tutorials/adding-custom-event-search-form-fields/
// https://wordpress.org/support/topic/search-event-form-disable-ajax-and-custom-fields/

// [events_search view="list" views="list" scope="all" category="357" limit="10" pagination="1"]
// [events_search view="list" views="list" scope="all" category="356" limit="10" pagination="1"]

// [event_list category="1,2,3,4"]
// [events view="list" scope="all" category="356" limit="10" pagination="1" show_search="1" has_search="1"]
// [events_list_grouped mode="yearly" category="356" limit="10" pagination="1" show_search="1" has_search="1"]
// [events_list scope="all" category="356" limit="10" pagination="1" show_search="1" has_search="1"]

