<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Enqueue scripts that change the Funding listings data via AJAX.
 */
function erua_enqueue_funding_search_script() {

    global $post;
    //global $wp;

    $funding_opportunities_page_id = ( get_field('funding_opportunities_page', 'option') ) ?? null;

    /**
     * If @ Science and Society - Funding Opportunities page
     */
    if ( $post && $funding_opportunities_page_id && $funding_opportunities_page_id === intval($post->ID) ) {

        // Enqueue the script in the footer!
        wp_enqueue_script('erua-ajax-search-opportunities', get_stylesheet_directory_uri() . '/assets/js/ajax-search-opportunities.js', '', '', true);

        global $wp_query;
        $qvars = $wp_query->query;
        //$qvars['testing'] = 'hmm';
        // Push the query vars to the above script
        wp_localize_script('erua-ajax-search-opportunities', 'ajax_query_data', ['query' => $qvars]);

        $params = [
            '_ajax_url' => admin_url('admin-ajax.php'),
            '_ajax_action' => 'the_funding_search', # load function hooked to: "wp_ajax_*" action hook
            //'_ajax_post_id' => get_the_ID(),
            /**
             * The nonce is generated based on the current time, 
             * the provided string argument, and the current user ID.
             * https://codex.wordpress.org/Function_Reference/wp_create_nonce
             */
            '_ajax_nonce' => wp_create_nonce('funding_filtering_nonce'),
        ];
        // Additionally push some necessary variables to the script
        wp_localize_script('erua-ajax-search-opportunities', 'ajax_object', $params);

    }

}
add_action('wp_enqueue_scripts', 'erua_enqueue_funding_search_script', 100);

//================================================================================
// AJAX ACTIONS.
//================================================================================

/**
 * This function filters Funding listings via AJAX.
 */
function erua_ajax_search_funding() {

    /*-------------------------------------------------------------------
        SECURITY
    -------------------------------------------------------------------*/

    /**
     * If the nonce is not set or incorrect, then check_ajax_referrer() 
     * will cause the AJAX call to die, protecting your AJAX call from invalid requests.
     * 
     * https://codex.wordpress.org/WordPress_Nonces
     */
    //check_ajax_referer('funding_filtering_nonce', 'ajaxnonce');
    if ( ! check_ajax_referer('funding_filtering_nonce', 'ajaxnonce') ) {
        wp_send_json_error();
    }

    // Note: Consider implementing some throttling mechanism to limit AJAX requests?
    // https://stackoverflow.com/questions/7082527/jquery-throttling-and-queuing-of-ajax-requests

    /*-------------------------------------------------------------------
        DEBUG FORM DATA
    -------------------------------------------------------------------*/

    // $html = '';
    // ob_start();

    // echo '<pre>';
    // var_dump($_POST['form_data']);
    // echo '</pre>';

    // $html = ob_get_contents();
    // ob_end_clean();

    // $response = [
    //     'html' => $html,
    // ];
    // wp_send_json_success($response);
    // die();

    /*-------------------------------------------------------------------
        GATHER ALL $_POST DATA
    -------------------------------------------------------------------*/

    $ajax_keyword_search = null;
    $ajax_funding_programmes = null;
    $ajax_funding_geographic_scope = null;
    $ajax_funding_scientific_fields = null;
    $ajax_funding_status = null;
    $ajax_deadline_search = null;

    if ( isset($_POST['form_data']['field_659a470b6102e']) ) {
        $ajax_keyword_search = ( strlen($_POST['form_data']['field_659a470b6102e'][0]) >=3 ) ? $_POST['form_data']['field_659a470b6102e'][0] : null;
    }
    if ( isset($_POST['form_data']['field_659a4a1fcf6bd']) ) {
        $ajax_funding_programmes = filter_var_array($_POST['form_data']['field_659a4a1fcf6bd'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_659a4ae64a317']) ) {
        $ajax_funding_geographic_scope = filter_var_array($_POST['form_data']['field_659a4ae64a317'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_659a4b41736e8']) ) {
        $ajax_funding_scientific_fields = filter_var_array($_POST['form_data']['field_659a4b41736e8'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_659a4bb82e6cb']) ) {
        $ajax_funding_status = filter_var_array($_POST['form_data']['field_659a4bb82e6cb'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_65bab9ad33309']) ) {
        // format: Ymd
        $ajax_deadline_search = filter_var_array($_POST['form_data']['field_65bab9ad33309'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    }

    $ajax_taxonomy = filter_var($_POST['form_data']['_ajax_taxonomy'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_taxonomy_rewrite_slug = filter_var($_POST['form_data']['_ajax_taxonomy_rewrite_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    //$ajax_category = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);

    //$query_args = filter_input(INPUT_POST, 'query_args', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
    $ajax_original_url = filter_var($_POST['form_data']['_ajax_original_page_url'], FILTER_VALIDATE_URL);
    $ajax_original_term_slug = filter_var($_POST['form_data']['_ajax_original_page_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_original_term_id = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);

    /*-------------------------------------------------------------------
        PROCESS DATA
    -------------------------------------------------------------------*/

    $funding_opportunity_programme_ids = [];
    $funding_opportunity_geographic_scope_ids = [];
    $funding_opportunity_scientific_field_ids = [];
    $funding_opportunity_status_ids = [];

    // Find all available funding programme terms
    $all_programmes = get_terms( [ 'taxonomy' => 'funding-programme', 'hide_empty' => false ] );

    // Find all available funding geographic scope terms
    $all_geographic_scopes = get_terms( [ 'taxonomy' => 'funding-geographic-scope', 'hide_empty' => false ] );

    // Find all available funding scientific field terms
    $all_scientific_fields = get_terms( [ 'taxonomy' => 'funding-scientific-field', 'hide_empty' => false ] );

    // Find all available funding opportunity status terms
    $all_statuses = get_terms( [ 'taxonomy' => 'funding-opportunity-status', 'hide_empty' => false ] );

    foreach ( $all_programmes as $programme ) {
        array_push($funding_opportunity_programme_ids, $programme->term_id);
    }

    foreach ( $all_geographic_scopes as $geographic_scope ) {
        array_push($funding_opportunity_geographic_scope_ids, $geographic_scope->term_id);
    }

    foreach ( $all_scientific_fields as $scientific_field ) {
        array_push($funding_opportunity_scientific_field_ids, $scientific_field->term_id);
    }

    foreach ( $all_statuses as $status ) {
        array_push($funding_opportunity_status_ids, $status->term_id);
    }

    // A provided funding opportunity programme can only be an existing funding-programme taxonomy
    if ( !empty($ajax_funding_programmes) ) {
        foreach( $ajax_funding_programmes as $programme ) {
            if ( !in_array( (int) $programme, $funding_opportunity_programme_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided funding opportunity geographic scope can only be an existing funding-geographic-scope taxonomy
    if ( !empty($ajax_funding_geographic_scope) ) {
        foreach( $ajax_funding_geographic_scope as $geographic_scope ) {
            if ( !in_array( (int) $geographic_scope, $funding_opportunity_geographic_scope_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided funding opportunity scientific field can only be an existing funding-scientific-field taxonomy
    if ( !empty($ajax_funding_scientific_fields) ) {
        foreach( $ajax_funding_scientific_fields as $scientific_field ) {
            if ( !in_array( (int) $scientific_field, $funding_opportunity_scientific_field_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided funding opportunity status can only be an existing funding-opportunity-status taxonomy
    if ( !empty($ajax_funding_status) ) {
        foreach( $ajax_funding_status as $status ) {
            if ( !in_array( (int) $status, $funding_opportunity_status_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    /*-------------------------------------------------------------------
        SET QUERY VARS
    -------------------------------------------------------------------*/

    $filters = [];

    if ( !empty($ajax_funding_programmes && $ajax_taxonomy !== 'funding-programme' ) ) {
        $temp = implode( ',', $ajax_funding_programmes );
        set_query_var('funding_programmes', $temp );
        $filters['funding_programmes'] = $temp;
    }
    if ( !empty($ajax_funding_geographic_scope) && $ajax_taxonomy !== 'funding-geographic-scope' ) {
        $temp = implode( ',', $ajax_funding_geographic_scope );
        set_query_var( 'funding_gs', $temp );
        $filters['funding_gs'] = $temp;
    }
    if ( !empty($ajax_funding_scientific_fields && $ajax_taxonomy !== 'funding-scientific-field' ) ) {
        $temp = implode( ',', $ajax_funding_scientific_fields );
        set_query_var('funding_sf', $temp );
        $filters['funding_sf'] = $temp;
    }
    if ( !empty($ajax_funding_status && $ajax_taxonomy !== 'funding-opportunity-status' ) ) {
        $temp = implode( ',', $ajax_funding_status );
        set_query_var('funding_status', $temp );
        $filters['funding_status'] = $temp;
    }
    if ( !empty($ajax_deadline_search) ) {
        $temp = implode( ',', $ajax_deadline_search );
        set_query_var('deadline', $temp);
        $filters['deadline'] = $temp;
    }
    if ( !empty($ajax_keyword_search) && strlen($ajax_keyword_search) >=3 ) {
        set_query_var('keywords', $ajax_keyword_search);
        $filters['keywords'] = $ajax_keyword_search;
    }
    //set_query_var('paged', 0);

    $query_string = http_build_query($filters);
    $query_string = ( empty($query_string) ) ? '?viewing=all' : '?'.$query_string;

    // If there is an AJAX-provided "viewing" filter, select it.
    //$ajax_filter = (!empty($query_args['viewing' ])) ? $query_args['viewing' ] : 'default';

    /*-------------------------------------------------------------------
        HANDLE PAGINATION
    -------------------------------------------------------------------*/

    /**
     * In order for pagination to work, we need to build again the base URL path.
     * The site_url() gets prepended automatically to the base.
     * 
     * Thus, if our base is "something/mypage/",
     * the base will become "https://mydomain/something/mypage/",
     * and pagination path will be appended to that e.g. "https://mydomain/something/mypage/page/x/"
     * 
     * // https://stackoverflow.com/questions/20150653/wordpress-pagination-not-working-with-ajax
     */
    $path = ( empty($ajax_taxonomy) )
    ? $ajax_original_term_slug . '/'
    : $ajax_taxonomy_rewrite_slug . '/' . $ajax_original_term_slug . '/';

    $base = $path . $query_string;

    $original_req_uri = $_SERVER['REQUEST_URI']; # "/wp-admin/admin-ajax.php"

    /**
     * Overwrite the REQUEST_URI variable on which 
     * pagination ("get_pagenum_link()") depends on in order to build its links
     */
    $_SERVER['REQUEST_URI'] = $base;

    /*-------------------------------------------------------------------
        BUILD NEW QUERY & RENDER THE NEW CONTENT
    -------------------------------------------------------------------*/

    /**
     * The security checks have passed 
     * and the user is allowed to run the specified query.
     * Create a new query!
     */
    $new_query_args = getFundingOpportunityQueryArguments($ajax_funding_programmes, $ajax_funding_geographic_scope, $ajax_funding_scientific_fields, $ajax_funding_status, null, null, $ajax_deadline_search, $ajax_keyword_search);

    // Will reset previous WP Query and clear all query vars!
    wp_reset_query();
    $wp_query = new WP_Query($new_query_args);

    $funding_taxonomies = []; // Cache with transients? https://developer.wordpress.org/apis/transients/
    $funding_taxonomies['funding-programme'] = get_taxonomy('funding-programme');
    $funding_taxonomies['funding-geographic-scope'] = get_taxonomy('funding-geographic-scope');
    $funding_taxonomies['funding-scientific-field'] = get_taxonomy('funding-scientific-field');
    $funding_taxonomies['funding-opportunity-status'] = get_taxonomy('funding-opportunity-status');

    $html = '';
    ob_start();

    include_once __DIR__ . '/listings-content.php';

    // echo '<pre>';
    // var_dump($new_query_args);
    // echo '</pre>';

    $html = ob_get_contents();
    ob_end_clean();

    // Restore the original REQUEST_URI - in case anything else would resort on it
    $_SERVER['REQUEST_URI'] = $original_req_uri;

    /*-------------------------------------------------------------------
        SEND RESPONSE
    -------------------------------------------------------------------*/
    $response = [
        'html' => $html,
        'query_string' => $query_string,
        'wp_query_args' => $new_query_args,
        'base_url' => $path,
        'results' => $wp_query->post_count
    ];
    wp_send_json_success($response);
    die(); // required. to end AJAX request.
}
// handling ajax action for logged-in users and guests
add_action('wp_ajax_the_funding_search', 'erua_ajax_search_funding');
add_action('wp_ajax_nopriv_the_funding_search', 'erua_ajax_search_funding');
