<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// Build the Breadcrumb trail.
//================================================================================

$breadcrumbs = [];
$society_landing_page_id = ( get_field('society_landing_page', 'option') ) ?? null;

// (1) Add the Site's home page to the breadcrumb trail
$breadcrumbs[] = [
    get_site_url(),
    __('Home', 'erua')
];

// (2) Add Module Root
if ( $society_landing_page_id ) {
    // Add the Site's home page to the breadcrumb trail
    $breadcrumbs[] = [
        get_permalink($society_landing_page_id),
        get_the_title($society_landing_page_id)
    ];
}

// (3) Add current view
if ( ! is_tax() && ! is_archive() && ! is_bbpress() && ! is_singular(['hackathon', 'funding-opportunity', 'job-opportunity']) && $society_landing_page_id !== get_the_ID() ) {
    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
// https://codex.bbpress.org/bbpress-conditional-tags/
else if ( is_bbpress() ) {    
    $science_shop_page_id = ( get_field('science_shop_page', 'option') ) ?? null;

    if ( $science_shop_page_id && $science_shop_page_id !== get_the_ID() ) {
        $breadcrumbs[] = [
            get_permalink($science_shop_page_id ),
            get_the_title($science_shop_page_id )
        ];
    }

    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
else if ( is_singular('hackathon') ) {
    $hackathons_page_id = ( get_field('hackathons_page', 'option') ) ?? null;

    if ( $hackathons_page_id ) {
        $breadcrumbs[] = [
            get_permalink($hackathons_page_id),
            get_the_title($hackathons_page_id)
        ];
    }

    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
else if ( is_singular('funding-opportunity') ) {
    $funding_opportunities_page_id = ( get_field('funding_opportunities_page', 'option') ) ?? null;

    if ( $funding_opportunities_page_id ) {
        $breadcrumbs[] = [
            get_permalink($funding_opportunities_page_id),
            get_the_title($funding_opportunities_page_id)
        ];
    }

    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
else if ( is_singular('job-opportunity') ) {
    $job_opportunities_page_id = ( get_field('job_opportunities_page', 'option') ) ?? null;

    if ( $job_opportunities_page_id ) {
        $breadcrumbs[] = [
            get_permalink($job_opportunities_page_id),
            get_the_title($job_opportunities_page_id)
        ];
    }

    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
else if ( is_tax() ) {
    global $page_url, $page_title;

    $breadcrumbs[] = [
        $page_url,
        $page_title
    ];
}
else if ( is_archive() ) {
    global $page_url, $page_title;

    $breadcrumbs[] = [
        $page_url,
        $page_title
    ];
}

//================================================================================
// Build the Module Title.
//================================================================================

$title = ( ! is_tax() && ! is_archive() ) ? get_the_title(get_the_ID()) : $page_title;

?>
<section class="module-top section science-society" style="padding-bottom: 0; z-index: 2;">
    <div class="bg section-bg fill bg-fill bg-loaded"></div>
    <div class="section-content relative">
        <div class="row row-full-width">
            <div class="col small-12 large-12" style="padding-bottom: 0;">
                <div class="col-inner">
                    <ol class="breadcrumb">
                        <?php foreach( $breadcrumbs as $breadcrumb ) : ?>
                        <li class="breadcrumb-item"><a href="<?php echo $breadcrumb[0]; ?>"><span><?php echo $breadcrumb[1]; ?></span></a></li>
                        <?php endforeach; ?>
                    </ol>
                    <div class="module-title"><h3 class="module-heading"><?php echo $title; ?></h3></div>
                    <?php echo do_shortcode('[society_menu]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>