<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
* Search Results Highlighting
*
* https://codex.wordpress.org/Template_Tags/get_search_query
* The search query string of the get_search_query() function 
* is passed through esc_attr() to ensure that it is safe for 
* placing in an html attribute.
*/
function highlight_search_term($text)
{
     if( !is_admin() && is_search() && in_the_loop() )
	 {
		 //$sr = get_query_var('s');
		 //$keys = explode(" ",$sr);
		 //$text = preg_replace('/('.implode('|', $keys) .')/iu', '<strong class="search-term">\0</strong>', $text);
		 $keys = implode('|', explode( ' ', trim(get_search_query()) ));
		 $text = preg_replace('/('. $keys .')/iu', '<strong class="search-term">\0</strong>', $text); // Can use $1 instead of \0
     }
     return $text;
}
//add_filter('wp_trim_excerpt', 'highlight_search_term', 10, 1);
add_filter('get_the_excerpt', 'highlight_search_term', 10, 1);
add_filter('the_title', 'highlight_search_term', 10, 1);

/**
 * Filter CPTs and pages
 * https://wordpress.org/plugins/search-exclude/
 * https://stackoverflow.com/questions/33091598/wordpress-how-to-remove-pages-from-search-results
 */
function erua_searchfilter($query) {
    //global $wp_post_types;
 
    // Don't show Requests in search for non-admins
    // if ( $query->is_search && !is_admin() && !current_user_can('administrator') ) {
    //     if ( post_type_exists( 'request' ) ) {

    //         // exclude from search results
    //         $wp_post_types['request']->exclude_from_search = true;
    //     }
    // }

    if ( ! $query->is_admin && $query->is_search && $query->is_main_query() ) {
        // Don't show certain pages in search
        //$query->set( 'post__not_in', array( 259, 142, 414, 911, 412, 909, 645, 758 ) );
		if ( $excluded_pages_array = get_field('search_excluded_pages', 'option') ) {
			$query->set( 'post__not_in', $excluded_pages_array );
		}
		//$query->set( 'post__not_in', array( 1221, 1472, 1322, 1052, 2038, 564, 566 ) );

        /**
         * Enable searching in topic tags
         * 
         * https://www.reddit.com/r/Wordpress/comments/20nhq5/simple_way_to_include_tags_in_wordpress_search/
         * https://stackoverflow.com/questions/22594454/wordpress-search-query-include-tags-and-limit-these-tags-to-specific-category
         */
        //$keywords_array = explode(" ", get_search_query());
        
        //$query->set('tag_slug__in', $keywords_array);
        // var_dump($keywords_array);
        // die();
        // echo "<pre>";
        // var_dump($wp_post_types);
        // echo "</pre>";
        // die();
    }

    return $query;
}
add_filter('pre_get_posts','erua_searchfilter');
