<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//-------------------------------------------------------------------
// (1) FOOTER STATS
//-------------------------------------------------------------------

function get_footer_stats_shortcode() {

    $count_posts = wp_count_posts('post');
    $count_aeiforia_projects = ( post_type_exists('aeiforia-project') ) ? wp_count_posts('aeiforia-project') : null;
    $count_eruahaus_projects = ( post_type_exists('eruahaus-project') ) ? wp_count_posts('eruahaus-project') : null;
    //$category_base = ( get_option( 'category_base' ) ) ? get_option( 'category_base' ) : 'category';

    echo '<div id="content-stats" style="display: flex; justify-content: flex-start;">
        <div style="display: flex; flex-direction: column; align-items: center; text-align: center; margin-right: 30px;">
        <i class="fa-solid fa-newspaper" style="font-size: 28px; line-height: 32px;" aria-hidden="true"></i>
        <span style="font-size: 28px; line-height: 32px;">'.$count_posts->publish.'</span>
        <a href="'.get_permalink( get_option( 'page_for_posts' ) ).'">'.__('Posts', 'erua').'</a>
        </div>
        <div style="display: flex; flex-direction: column; align-items: center; text-align: center; margin-right: 30px;">
        <i class="fa-solid fa-graduation-cap" style="font-size: 28px; line-height: 32px;" aria-hidden="true"></i>
        <span style="font-size: 28px; line-height: 32px;">'. ( ($count_aeiforia_projects) ? $count_aeiforia_projects->publish : '' ) .'</span>
        <a href="'.site_url().'/aeiforia-projects/">'.__('AEIFORIA projects', 'erua').'</a>
        </div>
        <div style="display: flex; flex-direction: column; align-items: center; text-align: center; margin-right: 30px;">
        <i class="fa-solid fa-graduation-cap" style="font-size: 28px; line-height: 32px;" aria-hidden="true"></i>
        <span style="font-size: 28px; line-height: 32px;">'. ( ($count_eruahaus_projects) ? $count_eruahaus_projects->publish : '' ) .'</span>
        <a href="'.site_url().'/eruahaus-projects/">'.__('ERUAHAUS projects', 'erua').'</a>
        </div>
        </div>';

}
add_shortcode( 'get_footer_stats', 'get_footer_stats_shortcode' );

/**
 * Display online users using the "WP-UserOnline" plugin.
 * 
 * Check plugin FAQ for more functions:
 * https://wordpress.org/plugins/wp-useronline/
 */
function get_online_users_shortcode() {

    /**
     * If the "WP-UserOnline" plugin by Lester 'GaMerZ' Chan,
     * is installed and activated, we'll use it to display
     * the number of online users.
     */
    if ( function_exists('users_online') ) {
        echo '<div id="useronline-count">';
        echo __('Currently we have', 'erua') . ' ';
        echo '<span style="pointer-events: none;">';
        echo users_online();
        echo '</span>';
        echo '</div>';
    }

}
add_shortcode( 'get_online_users', 'get_online_users_shortcode' );

//-------------------------------------------------------------------
// (2) GUTENBERG BLOCKS
//-------------------------------------------------------------------

/**
 * Print a Gutenberg Block of an embed video.
 *
 * Here is a complete list of embeds that Gutenberg officially supports (not all of them are videos):
 * 
 *  YouTube
 *  Twitter
 *  Facebook
 *  Instagram
 *  Vimeo
 *  Soundcloud
 *  Spotify
 *  Flickr
 *  Animoto
 *  Cloudup
 *  CollegeHumor
 * 
 * Resources:
 * https://stackoverflow.com/questions/65174327/how-can-i-insert-a-block-code-inside-a-php-page
 * https://github.com/WordPress/gutenberg/issues/19114
 * https://core.trac.wordpress.org/ticket/46457
 * 
 * @return void
 */
function get_video_embed_block_shortcode( $atts ) {
    global $wp_embed;
    //add_filter( 'the_content', array( $wp_embed, 'autoembed' ), 9);

    $attributes = shortcode_atts( array(
        'url' => ''
    ), $atts );

    if ( empty($attributes['url']) || filter_var($attributes['url'], FILTER_VALIDATE_URL) === false ) {
        return '';
    }

    $supported_providers = [
        'youtube.com'       => 'youtube',
        'youtu.be'          => 'youtube',
        'vimeo.com'         => 'vimeo',
        'dailymotion.com'   => 'dailymotion',
        'tiktok.com'        => 'tiktok'
    ];

    $video_url = $attributes['url'];
    $video_url_parts = parse_url( $video_url );
    $video_domain = $video_url_parts['host'];
    $provider = ltrim($video_domain, 'www.');

    if ( ! array_key_exists( $provider, $supported_providers ) ) {
        return '';
    }

    $provider_slug = $supported_providers[$provider];

    $aspect_ratio = ( $provider_slug !== 'tiktok' ) ? 'wp-embed-aspect-16-9 wp-has-aspect-ratio' : false;

    $block_content = '<!-- wp:embed {"url":"'.$attributes['url'].'","type":"video","providerNameSlug":"'.$provider_slug.'","responsive":true,"className":"'.$aspect_ratio.'"} -->
    <figure class="wp-block-embed is-type-video is-provider-'.$provider_slug.' wp-block-embed-'.$provider_slug.' '.$aspect_ratio.'"><div class="wp-block-embed__wrapper">
    '.$attributes['url'].'
    </div></figure>
    <!-- /wp:embed -->';

    $rendered_content = $wp_embed->autoembed( do_blocks( $block_content ) );

    echo $rendered_content;
}
add_shortcode( 'get_video_embed_block', 'get_video_embed_block_shortcode', 8 );

/**
 * Print a Gutenberg Block of a self-hosted video.
 */
function get_video_block_shortcode( $atts ) {
    global $wp_embed;

    $attributes = shortcode_atts( array(
        'fileid' => '',
        'url' => ''
    ), $atts );

    if ( empty($attributes['url']) || empty($attributes['fileid']) || filter_var($attributes['url'], FILTER_VALIDATE_URL) === false || !is_numeric($attributes['fileid']) ) {
        return '';
    }

    $block_content = '<!-- wp:video {"id":'.$attributes['fileid'].'} -->
    <figure class="wp-block-video"><video controls src="'.$attributes['url'].'"></video></figure>
    <!-- /wp:video -->';

    $rendered_content = $wp_embed->autoembed( do_blocks( $block_content ) );

    echo $rendered_content;
}
add_shortcode( 'get_video_block', 'get_video_block_shortcode', 8 );

//-------------------------------------------------------------------
// (3) USER ACCOUNT
//-------------------------------------------------------------------

function get_user_content_menu_shortcode( $atts ) {
    global $wp;
    $wp->parse_request();
    $current_url = rtrim(home_url($wp->request), '/');

    // $attributes = shortcode_atts( array(
    //     'url' => ''
    // ), $atts );

    $user_id = get_current_user_id();

    $eruahaus_projects = (int) count_user_posts( $user_id, 'eruahaus-project' );
    $showroom_presentations = (int) count_user_posts( $user_id, 'showroom' );
    $creative_blog_posts = (int) count_user_posts( $user_id, 'creative-blog-post' );
    $posts = (int) count_user_posts( $user_id, 'post' );
    $events = (int) count_user_posts( $user_id, 'event' );
    $content_sum = $eruahaus_projects + $showroom_presentations + $creative_blog_posts + $posts + $events;
    $current_post_type = ( get_query_var( 'content_type' ) ) ? sanitize_text_field( get_query_var( 'content_type' ) ) : null;

    $output = '';
    ob_start();

    if ( $content_sum > 0 ) : ?>
        <h3>
            <?php
            echo __('You\'ve made', 'erua') . ' ';
            echo sprintf( _n( '%s contribution', '%s contributions', $content_sum, 'erua' ), number_format_i18n($content_sum) );
            echo ' ' . __('on the ECOs platform', 'erua'); ?>
        </h3>
        <ul class="post-types-list">
            <?php if ( $eruahaus_projects > 0 ) : ?>
            <li class="post-type eruahaus-project<?php echo ( $current_post_type === 'eruahaus-project' ) ? ' active': ''; ?>">
                <a href="<?php echo $current_url; ?>" class="content-link" data-post-type="eruahaus-project">
                    <i class="fa-solid fa-graduation-cap" aria-hidden="true"></i>
                    <span class="posts-count"><?php echo $eruahaus_projects; ?></span>
                    <span class="post-type-title"><?php echo __('ERUAHaus Projects &amp; Teams', 'erua'); ?></span>
                </a>
            </li>
            <?php endif; ?>
            <?php if ( $showroom_presentations > 0 ) : ?>
            <li class="post-type showroom<?php echo ( $current_post_type === 'showroom' ) ? ' active': ''; ?>">
                <a href="<?php echo $current_url; ?>" class="content-link" data-post-type="showroom">
                    <i class="fa-solid fa-photo-film" aria-hidden="true"></i>
                    <span class="posts-count"><?php echo $showroom_presentations; ?></span>
                    <span class="post-type-title"><?php echo __('ShowRoom Presentations', 'erua'); ?></span>
                </a>
            </li>
            <?php endif; ?>
            <?php if ( $creative_blog_posts > 0 ) : ?>
            <li class="post-type creative-blog-post<?php echo ( $current_post_type === 'creative-blog-post' ) ? ' active': ''; ?>">
                <a href="<?php echo $current_url; ?>" class="content-link" data-post-type="creative-blog-post">
                    <i class="fa-regular fa-newspaper" aria-hidden="true"></i>
                    <span class="posts-count"><?php echo $creative_blog_posts; ?></span>
                    <span class="post-type-title"><?php echo __('Creative Blog Posts', 'erua'); ?></span>
                </a>
            </li>
            <?php endif; ?>
            <?php if ( $posts > 0 ) : ?>
            <li class="post-type post<?php echo ( $current_post_type === 'post' ) ? ' active': ''; ?>">
                <a href="<?php echo $current_url; ?>" class="content-link" data-post-type="post">
                    <i class="fa-solid fa-rss" aria-hidden="true"></i>
                    <span class="posts-count"><?php echo $posts; ?></span>
                    <span class="post-type-title"><?php echo __('ECOs News', 'erua'); ?></span>
                </a>
            </li>
            <?php endif; ?>
            <?php if ( $events > 0 ) : ?>
            <li class="post-type event<?php echo ( $current_post_type === 'event' ) ? ' active': ''; ?>">
                <a href="<?php echo $current_url; ?>" class="content-link" data-post-type="event">
                    <i class="fa-regular fa-calendar-days" aria-hidden="true"></i>
                    <span class="posts-count"><?php echo $events; ?></span>
                    <span class="post-type-title"><?php echo __('ECOs Events', 'erua'); ?></span>
                </a>
            </li>
            <?php endif; ?>
        </ul>
    <?php else : ?>
        <h3><?php echo __('You have not uploaded any content to the platform yet!', 'erua'); ?></h3>
    <?php endif;

    $output = ob_get_contents();
    ob_end_clean();

    return $output;
}
add_shortcode( 'get_user_content_menu', 'get_user_content_menu_shortcode' );

//-------------------------------------------------------------------
// (4) ERUAHAUS CREATIVE PROJECTS
//-------------------------------------------------------------------

function get_eruaner_projects_shortcode( $atts ) {

    if ( ! is_user_logged_in() || ! post_type_exists('eruahaus-project') ) {
        return '';
    }

    $user = wp_get_current_user();
    $allowed_roles = array('administrator', 'eruaner');

    if ( ! $user || ! array_intersect($allowed_roles, $user->roles) ) {
        return '';
    }

    $eruahaus_projects = (int) count_user_posts( $user->ID, 'eruahaus-project' );

    $output = '';
    ob_start();

    if ( $eruahaus_projects > 0 ) {
        if ( !wp_style_is( 'eruahaus-eruaner-projects-style', 'enqueued' ) ) wp_enqueue_style( 'eruahaus-eruaner-projects-style' );

        $query_args = [
            'post_type' => 'eruahaus-project',
            //'post_status' => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit'],
            'post_status' => 'publish',
            'orderby'     => 'date',
            'numberposts' => -1,
            //'numberposts' => '5',
            'author' => wp_get_current_user()->ID,
            'posts_per_page' => 10, # get_option('posts_per_page'),
            'paged' => ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1,
        ];
        // Will reset previous WP Query and clear all query vars!
        wp_reset_query();
        $wp_query = new WP_Query($query_args);
        ?>

        <section id="contributions-section">

        <div id="contributions-section-header">
            <div id="contributions-section-title" class="container section-title-container alt-divider"><h1 class="section-title section-title-center"><b></b><span class="section-title-main"><i class="fa-solid fa-flask-vial" aria-hidden="true"></i><?php _e('Your ERUAHAUS Projects', 'erua'); ?></span><b></b></h1></div>
            <div id="contributions-section-description">
            <?php echo '<span>' . __('Viewing all your submitted ERUAHAUS Projects', 'erua') . '</span>'; ?>
            </div>
            <div id="contributions-section-post-count">
            <span title="<?php printf( _n( "Viewing %s ERUAHAUS Project", "Viewing %s ERUAHAUS Projects out of %s ERUAHAUS Projects", $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?>">
            <?php
            printf( _n( "%s ERUAHAUS Project", "%s ERUAHAUS Projects", $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->found_posts ) );
            ?>
            </span>
            </div>
        </div>

        <?php if ( $wp_query->have_posts() ) : ?>

        <table id="contributions-table">
        <tbody id="contributions-table-body">

        <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>

        <tr>
            <td>
            <span class="contribution-link">
            <i class="fa-solid fa-link contribution-link-icon" aria-hidden="true"></i>
            <?php the_title( sprintf( '<a href="%s" title="'.esc_attr(get_the_title()).'">', esc_url( get_permalink() ) ), '</a>' ); ?>
            </span>
            <span class="contribution-info">
            <?php echo '<span class="contribution-date" title="' . __('Last updated:', 'erua') .' ' . get_the_modified_date('j F Y, H:i') .'"><i class="fa fa-calendar" aria-hidden="true" title="'.__('Date created', 'erua').'"></i> ' . get_the_time('j F Y, H:i') . '</span>'; ?>
            <?php
            if ( function_exists('bp_is_active') ) {
                $group_id = get_field('eruahaus_project_group_id', get_the_ID());

                if ( $group_id ) {
                    $group_obj = groups_get_group( (int) $group_id );
                    $project_group_url = bp_get_group_permalink( $group_obj );
                    echo '<a class="project-group-link" role="button" href="' . $project_group_url . 'admin/"><i class="fa-solid fa-users-viewfinder" aria-hidden="true"></i> ' . __('Manage Team Space', 'erua') . '</a>';
                }
            }
            echo '<a class="post-edit-link" role="button" href="' . get_edit_post_link(get_the_ID()) . '"><i class="fa-regular fa-pen-to-square" aria-hidden="true"></i> ' . __('Edit', 'erua') . '</a>';
            ?>
            </span>
            </td>
        </tr>

        <?php endwhile; ?>
        </tbody>
        </table>

        <?php
        if ( $wp_query->max_num_pages > 1 ) :
        ?>
            <div id="contributions-pagination" class="pagination contributions-pagination">
                <?php
                $big = 99999999999; // an unlikely big integer
                echo paginate_links( [
                    'base'            => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
                    //'base'            => str_replace( [ $big, '&#038;' ], [ '%#%', '&' ], get_pagenum_link( $big ) ),
                    'format'          => '/page/%#%', # '/page/%#%' or '?paged=%#%'
                    'current'         => max( 1, $wp_query->query_vars['paged'] ),
                    'total'           => $wp_query->max_num_pages,
                    'prev_text'       => __( '<span class="meta-nav"><i class="fa-solid fa-chevron-left" aria-hidden="true"></i></span> Previous', 'erua' ),
                    'next_text'       => __( 'Next <span class="meta-nav"><i class="fa-solid fa-chevron-right" aria-hidden="true"></i></span>', 'erua' ),
                ] );
                ?>
            </div>
        </section>       
        <?php
        endif; // $wp_query->max_num_pages
        ?>
        <?php
        else:
            echo '<p class="lead">' . __('No contributions were found', 'erua') . '</p>';
        endif; // $wp_query->have_posts()

        // Restore original post data.
        wp_reset_postdata();
    }

    echo do_shortcode('[block id="creative-projects-teams"]');

    $output = ob_get_contents();
    ob_end_clean();

    return $output;
}
add_shortcode( 'get_eruaner_projects', 'get_eruaner_projects_shortcode' );

//-------------------------------------------------------------------
// (5) HACKATHONS
//-------------------------------------------------------------------

function get_previous_hackathons_shortcode( $atts ) {

    if ( ! post_type_exists('hackathon') ) {
        return '';
    }

    /**
     * SELECT * FROM `wp_postmeta` WHERE `post_id` = 2377;
     * 
     * hackathon_date_start 2024-01-09 12:00:00
     * hackathon_date_end 2024-02-25 11:59:00
     */
    //$date_format = get_option( 'date_format' );
    //$time_format = get_option( 'time_format' );

    // echo '<pre>';
    // var_dump($date_format);
    // echo '</pre>';

    // echo '<pre>';
    // var_dump($time_format);
    // echo '</pre>';

    //Today's date
    //$date_now = date("{$date_format} {$time_format}", strtotime("now"));
    $date_now = date('d/m/Y H:i:s', strtotime("now")); 
    // Future date - the arg will look between today's date and this future date to see if the post fall within the 2 dates.
    $date_future = date('d/m/Y H:i:s', strtotime("+24 months"));
    // Future date - the arg will look between today's date and this past date to see if the post fall within the 2 dates.
    $date_past = date('d/m/Y H:i:s', strtotime("-24 months"));

    $meta_query1 = [
        'relation' => 'AND',
        [
            'relation' => 'OR',
            array(
            'key'     => 'hackathon_date_end',
            'value'   => $date_now,
            'type'     => 'DATE',
            'compare' => '>',
            ),
            array(
            'key'     => 'hackathon_date_end',
            'compare' => 'NOT EXISTS',
            ),
        ],
        [
            'relation' => 'OR',
            array(
                'key'    => 'hackathon_date_end',
                'compare'   => 'BETWEEN',
                'type'     => 'DATE',
                'value'   => array($date_past, $date_now),
            ),
            // if no end date has been set use start date
            array(
                'key'       => 'hackathon_date_start',
                'compare'   => 'BETWEEN',
                'type'     => 'DATE',
                'value'   => array($date_past, $date_now),
            ),
        ],
    ];

    $meta_query2 = [
        [
            'relation' => 'OR',
            array(
            'key'     => 'hackathon_date_end',
            'value'   => $date_now,
            'type'     => 'DATE',
            'compare' => '>',
            ),
            array(
            'key'     => 'hackathon_date_end',
            'compare' => 'NOT EXISTS',
            ),
        ]
    ];

    $meta_query3 = [
        [
            'relation' => 'OR',
            array(
            'key'     => 'hackathon_date_end',
            'value'   => $date_now,
            'type'     => 'DATETIME',
            'compare' => '>',
            ),
            array(
            'key'     => 'hackathon_date_end',
            'compare' => 'NOT EXISTS',
            ),
        ]
    ];

    $meta_query4 = [
        [
            'key'    => 'hackathon_date_end',
            'compare'   => '>',
            'value'   => $date_now,
        ]
    ];

    $meta_query_final = [
        [
            'relation' => 'OR',
            array(
                'key'    => 'hackathon_date_end',
                'compare'   => '>',
                'value'   => $date_now,
            ),
            array(
                'key'     => 'hackathon_date_end',
                'compare' => 'NOT EXISTS',
            ),
        ]
    ];

    // $meta_query5 = [
    //     [
    //         'key'    => 'hackathon_date_end',
    //         'compare'   => '>',
    //         'type'     => 'DATE',
    //         'value'   => current_time( 'mysql' ),
    //     ]
    // ];

    // $meta_query6 = [
    //     [
    //         'key'    => 'hackathon_date_end',
    //         'compare'   => '>',
    //         'type'     => 'DATETIME',
    //         'value'   => current_time( 'mysql' ),
    //     ]
    // ];

    // $meta_query7 = [
    //     [
    //         'key'    => 'hackathon_date_end',
    //         'compare'   => 'NOT EXISTS',
    //     ]
    // ];

    // Note : The 'type' DATE works with the 'compare' value BETWEEN 
    // only if the date is stored at the format YYYY-MM-DD and tested with this format.

    // $meta_query8 = [
    //     [
    //         'key'    => 'hackathon_date_end',
    //         'compare'   => 'BETWEEN',
    //         'type'     => 'DATETIME',
    //         'value'   => array($date_past, $date_now),
    //     ]
    // ];

    /**
     * ACF DATE QUERY
     * https://support.advancedcustomfields.com/forums/topic/orderingfiltering-wp_query-using-acf-date-field/
     * https://stackoverflow.com/questions/71644805/wp-query-and-acf-date-field-does-not-sort-right
     */
    $query_args = [
        'post_type' => 'hackathon',
        //'post_status' => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit'],
        'post_status' => 'publish',
        //'orderby'     => 'date',
        'meta_key' => 'hackathon_date_end',
        'meta_type' => 'DATETIME',
        'orderby'	=> 'meta_value_num',
        'order'		=> 'ASC',
        'date_format'    => '%Y-%m-%d',
        //'nopaging'  => true,
        'numberposts' => -1,
        //'numberposts' => '5',
        //'author' => wp_get_current_user()->ID,
        'posts_per_page' => 10, # get_option('posts_per_page'),
        'paged' => ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1,
        // https://developer.wordpress.org/reference/classes/wp_meta_query/
        'meta_query' => $meta_query_final
    ];
    $wp_query = new WP_Query($query_args);

    $output = '';
    ob_start();

    // echo '<pre>';
    // var_dump($wp_query->found_posts);
    // echo '</pre>';

    // echo '<pre>';
    // var_dump($wp_query->post_count);
    // echo '</pre>';

    // echo '<pre>';
    // var_dump($date_now);
    // echo '</pre>';
    
    // echo '<pre>';
    // var_dump($date_past);
    // echo '</pre>';

    if ( $wp_query->have_posts() ) : 

        if ( !wp_style_is( 'previous-hackathons-style', 'enqueued' ) ) wp_enqueue_style( 'previous-hackathons-style' ); ?>

        <ul class="previous-hackathons-list">
        <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
        <li class="previous-hackathon">
            <div class="previous-hackathon-info">
                <h2 class="previous-hackathon-title"><a class="previous-hackathon-link two-line-box" href="<?php echo get_permalink(); ?>" title="<?php echo esc_attr(get_the_title()); ?>">
                    <span class="hackathon-text"><?php echo get_the_title(); ?></span>
                </a></h2>
                <p class="text-left">
                <?php
                $datestart = DateTime::createFromFormat('d/m/Y H:i:s', get_field('hackathon_date_start', get_the_ID()));
                $dateend = DateTime::createFromFormat('d/m/Y H:i:s', get_field('hackathon_date_end', get_the_ID()));

                if ( $datestart ) echo '<span>' . __('Began @ ') . '<strong>' . $datestart->format('d/m/Y H:i') . ' UTC</strong></span>';
                if ( $datestart && $dateend ) echo ' - <span>' . __('Ended @ ') . '<strong>' . $dateend->format('d/m/Y H:i') . ' UTC</strong></span>';
                ?>
                </p>
            </div>
            <?php if ( has_post_thumbnail() ) : ?>
            <div class="previous-hackathon-image">
                <a class="previous-hackathon-link" href="<?php echo get_permalink(); ?>" title="<?php echo esc_attr(get_the_title()); ?>"><?php the_post_thumbnail('thumbnail') ?></a>
            </div>
            <?php endif; ?>
        </li>
        <?php endwhile; // end of the loop. ?>
        </ul>

        <div id="hackathons-pagination" class="pagination hackathons-pagination">
        <?php
        $big = 99999999999; // an unlikely big integer
        // https://wordpress.stackexchange.com/questions/303297/paginate-link-generate-additional-038-whenever-my-url-have-multiple-query-stri
        echo paginate_links( [
            //'base'            => str_replace( $big, '%#%', html_entity_decode( get_pagenum_link( $big ) ) ),
            'base'            => str_replace( [ $big, '&#038;' ], [ '%#%', '&' ], get_pagenum_link( $big ) ),
            //'base'            => str_replace( $big, '%#%', get_pagenum_link( $big, false ) ),
            'format'          => '/page/%#%', # '/page/%#%' or '?paged=%#%'
            'current'         => max( 1, $wp_query->query_vars['paged'] ),
            'total'           => $wp_query->max_num_pages,
            'prev_text'       => __( '<span class="meta-nav"><i class="fa-solid fa-chevron-left" aria-hidden="true"></i></span> Previous', 'erua' ),
            'next_text'       => __( 'Next <span class="meta-nav"><i class="fa-solid fa-chevron-right" aria-hidden="true"></i></span>', 'erua' ),
        ] );
        ?>
        </div>
    <?php else :
    echo '<p style="text-align: center; font-size: 2em; margin-top: 50px;">' . __('No finished Hackathons found.', 'erua') . '</p>';
    endif;

    $output = ob_get_contents();
    ob_end_clean();

    wp_reset_postdata();

    return $output;
}
add_shortcode( 'get_previous_hackathons', 'get_previous_hackathons_shortcode' );

function get_featured_hackathons_shortcode( $atts ) {

    if ( ! post_type_exists('hackathon') ) {
        return '';
    }

    $meta_query = [
        [
            'key'    => 'hackathon_is_featured',
            'compare'   => '=',
            'type'     => 'NUMERIC',
            'value'   => 1,
        ]
    ];

    $query_args = [
        'post_type' => 'hackathon',
        //'post_status' => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit'],
        'post_status' => 'publish',
        //'orderby'     => 'date',
        'meta_key' => 'hackathon_date_start',
        'meta_type' => 'DATE',
        'orderby'	=> 'meta_value_num',
        'order'		=> 'DESC',
        // https://stackoverflow.com/questions/42913284/why-set-numberposts-to-1
        // "numberposts does not have an effect when used as an argument to WP_Query"
        'numberposts' => 1,
        'posts_per_page' => 1,
        // https://wordpress.stackexchange.com/questions/181541/how-to-limit-the-number-of-posts-that-wp-query-gets
        'no_found_rows' => true,
        //'numberposts' => '5',
        //'author' => wp_get_current_user()->ID,
        //'posts_per_page' => 10, # get_option('posts_per_page'),
        //'paged' => ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1,
        // https://developer.wordpress.org/reference/classes/wp_meta_query/
        'meta_query' => $meta_query
    ];
    $wp_query = new WP_Query($query_args);

    $output = '';
    ob_start();

    if ( $wp_query->have_posts() ) :
        if ( !wp_style_is( 'featured-hackathons-style', 'enqueued' ) ) wp_enqueue_style( 'featured-hackathons-style' );
        while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
            <div class="featured-hackathon">
                <div class="featured-hackathon-info">
                    <p class="text-center"><?php _e('FORTHCOMING (FEATURED) HACKATHON', 'erua'); ?></p>
                    <h2 class="featured-hackathon-title"><a class="featured-hackathon-link two-line-box" href="<?php echo get_permalink(); ?>" title="<?php echo esc_attr(get_the_title()); ?>">
                        <span class="featured-hackathon-text"><?php echo get_the_title(); ?></span>
                    </a></h2>
                    <p class="text-left">
                    <?php
                    $datestart = DateTime::createFromFormat('d/m/Y H:i:s', get_field('hackathon_date_start', get_the_ID()));
                    $dateend = DateTime::createFromFormat('d/m/Y H:i:s', get_field('hackathon_date_end', get_the_ID()));

                    if ( $datestart ) echo '<span>' . __('Begins @ ') . '<strong>' . $datestart->format('d/m/Y H:i') . ' UTC</strong></span>';
                    if ( $datestart && $dateend ) echo ' - <span>' . __('Ends @ ') . '<strong>' . $dateend->format('d/m/Y H:i') . ' UTC</strong></span>';
                    ?>
                    </p>
                    <?php if ( $hackathon_short_description = get_field('hackathon_short_description', get_the_ID()) ) : ?>
                    <p><?php echo $hackathon_short_description; ?><p>
                    <?php endif; ?>
                    <div class="featured-hackathon-more-button-container"><a class="featured-hackathon-more-button" target="_blank" href="<?php echo get_permalink(); ?>"><?php _e('See more', 'erua') ?></a></div>
                </div>
                <?php if ( has_post_thumbnail() ) : ?>
                <div class="featured-hackathon-image">
                    <a class="featured-hackathon-link" href="<?php echo get_permalink(); ?>" title="<?php echo esc_attr(get_the_title()); ?>"><?php the_post_thumbnail('medium') ?></a>
                </div>
                <?php endif; ?>
            </div>
        <?php endwhile; // end of the loop.
    endif;

    $output = ob_get_contents();
    ob_end_clean();

    wp_reset_postdata();

    return $output;
}
add_shortcode( 'get_featured_hackathons', 'get_featured_hackathons_shortcode' );
