<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Add new query variables in the list of public query variables, 
 * so that we can use it in our custom URLs.
 * https://codex.wordpress.org/Function_Reference/get_query_var
 */
function add_public_query_vars_for_user_contributions( $qvars ) {
    $myvars = [
        "content_type"
    ];
    foreach ( $myvars as $key ) {
        if ( ! array_key_exists( $key, $qvars ) ) {
            $qvars[] = $key;
        }
    }

    return $qvars;
}
add_filter( 'query_vars', 'add_public_query_vars_for_user_contributions' );

/**
 * This function refreshes content listings via AJAX.
 */
function erua_ajax_refresh_own_content() {

    /*-------------------------------------------------------------------
        DEBUG
    -------------------------------------------------------------------*/

    // $html = '';
    // ob_start();

    // echo '<pre>';
    // var_dump($_POST);
    // echo '</pre>';

    // $html = ob_get_contents();
    // ob_end_clean();

    // $response = [
    //     'html' => $html,
    // ];
    // wp_send_json_success($response);
    // die();

    /*-------------------------------------------------------------------
        SECURITY
    -------------------------------------------------------------------*/

    /**
     * If the nonce is not set or incorrect, then check_ajax_referrer() 
     * will cause the AJAX call to die, protecting your AJAX call from invalid requests.
     * 
     * https://codex.wordpress.org/WordPress_Nonces
     */
    //check_ajax_referer('library_document_filtering_nonce', 'ajaxnonce');
    if ( ! check_ajax_referer('account_own_content_refreshing_nonce', 'ajaxnonce') ) {
        wp_send_json_error();
    }

    if ( ! is_user_logged_in() ) {
        wp_send_json_error();
    }

    /*-------------------------------------------------------------------
        GATHER ALL $_POST DATA
    -------------------------------------------------------------------*/

    //$args = (array) filter_var(INPUT_POST, 'query');
    $query_args = filter_input(INPUT_POST, 'query_args', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
    $user_post_type = filter_input(INPUT_POST, 'post_type', FILTER_SANITIZE_SPECIAL_CHARS);

    /*-------------------------------------------------------------------
        PROCESS DATA
    -------------------------------------------------------------------*/

    if ( ! $user_post_type || ! post_type_exists($user_post_type) ) {
        //wp_send_json_error('Type Error');
        die();
    }

    /*-------------------------------------------------------------------
        SET QUERY VARS
    -------------------------------------------------------------------*/

    $filters = [];

    set_query_var('content_type', $user_post_type );
    $filters['content_type'] = $user_post_type;

    $query_string = http_build_query($filters);
    $query_string = '?'.$query_string;

    /*-------------------------------------------------------------------
        HANDLE PAGINATION
    -------------------------------------------------------------------*/

    $user_content_page_id = get_field('my_content_page', 'option') ?? null;

    /**
     * In order for pagination to work, we need to build again the base URL path.
     * The site_url() gets prepended automatically to the base.
     * 
     * Thus, if our base is "something/mypage/",
     * the base will become "https://mydomain/something/mypage/",
     * and pagination path will be appended to that e.g. "https://mydomain/something/mypage/page/x/"
     * 
     * // https://stackoverflow.com/questions/20150653/wordpress-pagination-not-working-with-ajax
     */
    $path = ($user_content_page_id && $mycontent_page_slug = get_post_field( 'post_name', $user_content_page_id) ) ?  $mycontent_page_slug . '/' : 'my-content/';

    $base = $path . $query_string;

    $original_req_uri = $_SERVER['REQUEST_URI']; # "/wp-admin/admin-ajax.php"

    /**
     * Overwrite the REQUEST_URI variable on which 
     * pagination ("get_pagenum_link()") depends on in order to build its links
     */
    $_SERVER['REQUEST_URI'] = $base;

    /*-------------------------------------------------------------------
        BUILD NEW QUERY & RENDER THE NEW CONTENT
    -------------------------------------------------------------------*/

    /**
     * The security checks have passed 
     * and the user is allowed to run the specified query.
     * Create a new query!
     */
    $new_query_args = [
        'post_type' => $user_post_type,
        //'post_status' => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit'],
        'post_status' => 'publish',
        'orderby'     => 'date',
        'numberposts' => -1,
        //'numberposts' => '5',
        'author' => wp_get_current_user()->ID,
        'posts_per_page' => 10, # get_option('posts_per_page'),
        'paged' => ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1,
    ];
    // echo '<pre>';
    // var_dump($new_query_args);
    // echo '</pre>';
    // die();
    // Will reset previous WP Query and clear all query vars!
    wp_reset_query();
    $wp_query = new WP_Query($new_query_args);

    $html = '';
    ob_start();

    //echo $user_post_type;
    require_once __DIR__ . '/../../template-parts/user-contributions.php';

    $html = ob_get_contents();
    ob_end_clean();

    // Restore the original REQUEST_URI - in case anything else would resort on it
    $_SERVER['REQUEST_URI'] = $original_req_uri;

    /*-------------------------------------------------------------------
        SEND RESPONSE
    -------------------------------------------------------------------*/
    $response = [
        'html' => $html,
        'query_string' => $query_string,
        //'wp_query_args' => $new_query_args,
        'base_url' => $path,
        //'results' => $wp_query->post_count
    ];
    wp_send_json_success($response);
    die(); // required. to end AJAX request.
}
add_action('wp_ajax_the_own_content_syncing', 'erua_ajax_refresh_own_content');
//add_action('wp_ajax_nopriv_the_own_content_syncing', 'erua_ajax_refresh_own_content');
