<?php

/**
 * Custom Categories widget.
 * 
 * Resources:
 * https://lonewolfonline.net/creating-wordpress-widgets/
 * https://www.hostinger.com/tutorials/how-to-create-custom-widget-in-wordpress
 * 
 * Changes from original Widget:
 * - Line 33: Added 'depth' => 2 in $cat_args
 */
class Custom_Categories_Widget extends WP_Widget_Categories {

    function widget( $args, $instance ) {
        static $first_dropdown = true;

		$default_title = __( 'Categories' );
		$title         = ! empty( $instance['title'] ) ? $instance['title'] : $default_title;

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$count        = ! empty( $instance['count'] ) ? '1' : '0';
		$hierarchical = ! empty( $instance['hierarchical'] ) ? '1' : '0';
		$dropdown     = ! empty( $instance['dropdown'] ) ? '1' : '0';

		echo $args['before_widget'];

		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		if ( 'aeiforia-project' === get_post_type() ) {
			$taxonomy = 'aeiforia-project-category';
		}
		else if ( 'eruahaus-project' === get_post_type() ) {
			$taxonomy = 'eruahaus-project-focus-area';
		}
		else if ( 'showroom' === get_post_type() ) {
			$taxonomy = 'showroom';
		}
		else if ( 'creative-blog-post' === get_post_type() ) {
			$taxonomy = 'creative-blog-post';
		}
		// else if ( 'hackathon' === get_post_type() ) {
		// 	$taxonomy = 'hackathon-category';
		// }
		else if ( 'funding-opportunity' === get_post_type() ) {
			$taxonomy = 'funding-scientific-field';
		}
		else if ( 'job-opportunity' === get_post_type() ) {
			$taxonomy = 'job-opportunity-field';
		}
		else {
			$taxonomy = 'category';
		}

		$cat_args = array(
			'depth'		   => 2,
			'orderby'      => 'name',
			'show_count'   => $count,
			'hierarchical' => $hierarchical,
			'taxonomy'     => $taxonomy,
            'suppress_filters' => false
		);

		if ( $dropdown ) {
			printf( '<form action="%s" method="get">', esc_url( home_url() ) );
			$dropdown_id    = ( $first_dropdown ) ? 'cat' : "{$this->id_base}-dropdown-{$this->number}";
			$first_dropdown = false;

			echo '<label class="screen-reader-text" for="' . esc_attr( $dropdown_id ) . '">' . $title . '</label>';

			$cat_args['show_option_none'] = __( 'Select Category' );
			$cat_args['id']               = $dropdown_id;

			/**
			 * Filters the arguments for the Categories widget drop-down.
			 *
			 * @since 2.8.0
			 * @since 4.9.0 Added the `$instance` parameter.
			 *
			 * @see wp_dropdown_categories()
			 *
			 * @param array $cat_args An array of Categories widget drop-down arguments.
			 * @param array $instance Array of settings for the current widget.
			 */
			wp_dropdown_categories( apply_filters( 'widget_categories_dropdown_args', $cat_args, $instance ) );

			echo '</form>';

			$type_attr = current_theme_supports( 'html5', 'script' ) ? '' : ' type="text/javascript"';
			?>

<script<?php echo $type_attr; ?>>
/* <![CDATA[ */
(function() {
	var dropdown = document.getElementById( "<?php echo esc_js( $dropdown_id ); ?>" );
	function onCatChange() {
		if ( dropdown.options[ dropdown.selectedIndex ].value > 0 ) {
			dropdown.parentNode.submit();
		}
	}
	dropdown.onchange = onCatChange;
})();
/* ]]> */
</script>

			<?php
		} else {
			$format = current_theme_supports( 'html5', 'navigation-widgets' ) ? 'html5' : 'xhtml';

			/** This filter is documented in wp-includes/widgets/class-wp-nav-menu-widget.php */
			$format = apply_filters( 'navigation_widgets_format', $format );

			if ( 'html5' === $format ) {
				// The title may be filtered: Strip out HTML and make sure the aria-label is never empty.
				$title      = trim( strip_tags( $title ) );
				$aria_label = $title ? $title : $default_title;
				echo '<nav role="navigation" aria-label="' . esc_attr( $aria_label ) . '">';
			}
			?>

			<ul>
				<?php
				$cat_args['title_li'] = '';
				$cat_args['use_desc_for_title'] = false;

				/**
				 * Filters the arguments for the Categories widget.
				 *
				 * @since 2.8.0
				 * @since 4.9.0 Added the `$instance` parameter.
				 *
				 * @param array $cat_args An array of Categories widget options.
				 * @param array $instance Array of settings for the current widget.
				 */
				wp_list_categories( apply_filters( 'widget_categories_args', $cat_args, $instance ) );
				?>
			</ul>

			<?php
			if ( 'html5' === $format ) {
				echo '</nav>';
			}
		}

		echo $args['after_widget'];
    }

}
