<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Fetch widgets
 */

require_once 'class-custom-archives-widget.php'; new custom_archives_widget; # Load 'Custom Archives' widget
require_once 'class-custom-categories-widget.php'; new custom_categories_widget; # Load 'Custom Categories' widget
require_once 'class-custom-recent-comments-widget.php'; new custom_categories_widget; # Load 'Custom Recent Comments' widget
require_once 'class-custom-recent-posts-widget.php'; new flatsome_recent_post_widget_enhanced; # Load 'Custom Recent Posts' widget
require_once 'class-custom-search-widget.php'; new custom_search_widget; # Load 'Custom Search' widget

function my_widgets_registration() {

    unregister_widget( 'WP_Widget_Archives' );
    register_widget( 'Custom_Archives_Widget' );

    unregister_widget( 'WP_Widget_Categories' );
    register_widget( 'Custom_Categories_Widget' );

    unregister_widget( 'WP_Widget_Recent_Comments' );
    register_widget( 'Custom_Recent_Comments_Widget' );

    register_widget( 'Flatsome_Recent_Post_Widget_Enhanced' );

    unregister_widget( 'WP_Widget_Search' );
    register_widget( 'Custom_Search_Widget' );

    //unregister_sidebar('aeiforia-sidebar');
    //unregister_sidebar('eruahaus-sidebar');
    //unregister_sidebar('eruahaus-showroom-sidebar');
    //unregister_sidebar('eruahaus-creative-blog-sidebar');
    //unregister_sidebar('hackathons-sidebar');
    //unregister_sidebar('funding-opportunities-sidebar');
    //unregister_sidebar('job-opportunities-sidebar');

    register_sidebar(
        [
            'name'          => __( 'AEIFORIA Sidebar', 'erua' ),
            'id'            => 'aeiforia-sidebar',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title' => '<span class="widget-title">', 
            'after_title' => '</span><div class="is-divider small"></div>'
        ]
    );

    register_sidebar(
        [
            'name'          => __( 'ERUAHAUS Sidebar', 'erua' ),
            'id'            => 'eruahaus-sidebar',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title' => '<span class="widget-title">', 
            'after_title' => '</span><div class="is-divider small"></div>'
        ]
    );

    register_sidebar(
        [
            'name'          => __( 'ERUAHAUS ShowRoom Sidebar', 'erua' ),
            'id'            => 'eruahaus-showroom-sidebar',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title' => '<span class="widget-title">', 
            'after_title' => '</span><div class="is-divider small"></div>'
        ]
    );

    register_sidebar(
        [
            'name'          => __( 'ERUAHAUS Creative Blog Sidebar', 'erua' ),
            'id'            => 'eruahaus-creative-blog-sidebar',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title' => '<span class="widget-title">', 
            'after_title' => '</span><div class="is-divider small"></div>'
        ]
    );

    register_sidebar(
        [
            'name'          => __( 'Hackathons Sidebar', 'erua' ),
            'id'            => 'hackathons-sidebar',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title' => '<span class="widget-title">', 
            'after_title' => '</span><div class="is-divider small"></div>'
        ]
    );

    register_sidebar(
        [
            'name'          => __( 'Funding Opportunities Sidebar', 'erua' ),
            'id'            => 'funding-opportunities-sidebar',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title' => '<span class="widget-title">', 
            'after_title' => '</span><div class="is-divider small"></div>'
        ]
    );

    register_sidebar(
        [
            'name'          => __( 'Job Opportunities Sidebar', 'erua' ),
            'id'            => 'job-opportunities-sidebar',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title' => '<span class="widget-title">', 
            'after_title' => '</span><div class="is-divider small"></div>'
        ]
    );

}
add_action( 'widgets_init', 'my_widgets_registration' );

/**
 * Don't show widget titles
 */
function erua_remove_widget_titles($widget_title)
{
    return null;
}
//add_filter('widget_title','erua_remove_widget_titles');
