<?php
/**
 * Template Name: ERUAHAUS Page
 * Template Post Type: page
 *
 * This page template is solely used by the pages
 * in the ERUAHAUS module.
 */

//================================================================================
// Page Access Control.
//================================================================================

$login_required = get_field('page_access_requires_login');

if ( !is_admin() && $login_required ) {
    $user = wp_get_current_user();
    $allowed_user_roles = get_field('page_access_allowed_roles');
    $user_is_logged_in = is_user_logged_in();
    $user_is_allowed = true;

    if ( $user_is_logged_in && is_array($allowed_user_roles) && empty(array_intersect($allowed_user_roles, $user->roles)) ) {
        $user_is_allowed = false;
    }

    if ( !$user_is_logged_in || ( $user_is_logged_in && !$user_is_allowed && !current_user_can('administrator') ) ) {
        
        $redirect_to_url = get_field('page_access_guests_redirect_url');

        if ( isset($redirect_to_url) ) {
            wp_safe_redirect( $redirect_to_url );
            exit;
        }
        else {
            wp_safe_redirect( site_url('/') );
            exit;
        }
    }
}

//================================================================================
// Get header.
//================================================================================

get_header();

//================================================================================
// Display page.
//================================================================================
do_action( 'flatsome_before_page' );
?>

<div id="content" role="main" class="content-area">

    <?php require_once __DIR__ . '/../includes/eruahaus/module-top-section.php'; ?>
    <div class="container" style="padding-bottom: 20px;">
    <?php while ( have_posts() ) : the_post(); ?>

        <?php the_content(); ?>

    <?php endwhile; // end of the loop. ?>
    </div>
</div>

<?php
do_action( 'flatsome_after_page' );
//================================================================================
// Get footer.
//================================================================================

get_footer();
