<?php
/**
 * Template Name: ERUAHAUS ShowRoom
 * Template Post Type: page
 * 
 * This page template is solely used by the page
 * that lists the ERUAHAUS ShowRoom Presentations.
 */

//================================================================================
// Generate CSS class for menus.
//================================================================================

/**
 * The nav_menu_css_class filter will let you add CSS classes to specific menu items.
 * We combine that with the get_page_template_slug function to fetch the page template filename, 
 * then we use that with the get_page_templates method of the theme class to get the template name 
 * as defined in the Template Name: header. 
 * 
 * Then we pass that result through sanitize_html_class to make it a valid class name. 
 * Lastly, we add it to the array of classes and return it.
 *
 * https://wordpress.stackexchange.com/a/169818
 */
function showroom_archive_page_template_nav_class( $classes, $item ) {
    // only check pages
    if ( 'page' == $item->object ) {
        // if this page has a template assigned
        if( $slug = get_page_template_slug( $item->object_id ) ) {
            // get the array of filenames => template names in the current theme
            $templates = wp_get_theme()->get_page_templates();
            // if there is a template with key matching our filename
            if( isset( $templates[$slug] ) ) {
                // sanitize it and add it to the classes
                $classes[] = sanitize_html_class( $templates[$slug] );
                //$classes[] = 'current-menu-item';
            }
        }
    }
    return $classes;
}
add_filter( 'nav_menu_css_class', 'showroom_archive_page_template_nav_class', 10, 2 );

//================================================================================
// Setup CSS and JS.
//================================================================================

function setup_showroom_styles() {
    wp_enqueue_style( 'eruahaus-showroom-archive-style' );
    wp_enqueue_style( 'acf-forms-style' );
}
add_action('wp_head', 'setup_showroom_styles');

//================================================================================
// Setup Page Title.
//================================================================================

function setup_showroom_page_title() {
    global $current_term_name, $post;

    if ( is_tax( ['showroom-category'] ) ) {
        return __('ShowRoom', 'erua') . ' | ' . $current_term_name . ' &#8211; ' . get_bloginfo( 'name' );
    }
    else {
        //return $post->post_title . ' &#8211; ' . get_bloginfo( 'name' );
        return __('ShowRoom', 'erua') . ' &#8211; ' . get_bloginfo( 'name' );
    }

}
add_filter( 'pre_get_document_title', 'setup_showroom_page_title' );

//================================================================================
// Gather page information.
//================================================================================

//$maxposts = get_option('posts_per_page');
//$paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;

$showroom_taxonomies = []; // Cache with transients? https://developer.wordpress.org/apis/transients/
$showroom_taxonomies['showroom-category'] = get_taxonomy('showroom-category');
$showroom_taxonomies['showroom-tag'] = get_taxonomy('showroom-tag');

/**
 * If we are viewing a ShowRoom custom taxonomy page,
 * then store the custom taxonomy's term in order to use
 * it with WP_Query().
 */
if ( is_tax( ['showroom-category'] ) ) {
    $current_term_object = get_queried_object();
    $current_term_object_id = $current_term_object->ID;
    $current_term_taxonomy_name = $current_term_object->taxonomy;
    $current_term_taxonomy_name_rewrite_slug = $eruahaus_taxonomies["{$current_term_taxonomy_name}"]->rewrite['slug'];
    $current_term_id = $current_term_object->term_id;
    $current_term_slug = $current_term_object->slug;
    $current_term_name = $current_term_object->name;
    $page_title = $current_term_name;
    //$current_term_description_first_line = rtrim(strtok($current_term_object->description, "\n")); # Assign first line of category's description
    //$current_term_description_fragments = explode('# Using vector graphic:', $current_term_description_first_line);
    //$current_term_image = esc_html(trim($current_term_description_fragments[1]));

    // If viewing a specific term
    if ( $current_term_slug ) {
        wp_localize_script( 'erua-ajax-filter-presentations', 'ajax_taxonomy_archive', $current_term_slug);
        $page_url = get_term_link( $current_term_slug, $current_term_taxonomy_name);
        $page_slug = $current_term_slug;
    }
    // Else viewing all terms (404)
    else {
        wp_localize_script( 'erua-ajax-filter-presentations', 'ajax_taxonomy_archive', 'all');
        $page_url = esc_url( get_permalink( get_queried_object_id() ) );
        $page_slug = get_post_field( 'post_name', get_queried_object_id() );
    }
}
// Else not in an ShowRoom Taxonomy view
else {
    $current_term_taxonomy_name = null;
    $current_term_taxonomy_name_rewrite_slug = null;
    $current_term_id = null;
    $current_term_slug = null;
    $current_term_name = null;
    $page_url = esc_url( get_permalink( get_queried_object_id() ) );
    $page_slug = '';
    $page_title = get_post_field( 'post_title', get_queried_object_id() );

    $parent_pages = get_post_ancestors(get_queried_object_id());
    if ( $parent_pages ) {
        foreach ( $parent_pages as $pid ) {
            $slug = get_post_field( 'post_name', $pid );
            if ( $slug ) {
                $page_slug .= $slug . '/';
            }
        }
    }
    $page_slug .= get_post_field( 'post_name', get_queried_object_id() );
}

//================================================================================
// Build the Query.
//================================================================================

/**
 * These query vars must have been previously declared in the 'query_vars' filter hook,
 * in order to be recognized by WP_Query and get retrieved from the URL.
 */
$showroom_category_filter = ( is_tax('showroom-category') )
    ? $current_term_id
    : ( ( get_query_var( 'showroom_category' ) ) ? sanitize_text_field( get_query_var( 'showroom_category' ) ) : null );

$showroom_tag_filter = ( is_tax('showroom-tag') )
    ? $current_term_id
    : ( ( get_query_var( 'showroom_tag' ) ) ? sanitize_text_field( get_query_var( 'showroom_tag' ) ) : null );

// echo 'paged: ' . get_query_var( 'paged' );

$showroom_category_terms = array_filter( explode(',', $showroom_category_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$showroom_tag_terms = array_filter( explode(',', $showroom_tag_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );

$query_args = getShowRoomQueryArguments($showroom_category_terms, $showroom_tag_terms);

// echo '<pre>';
// var_dump($showroom_category_terms, $showroom_tag_terms);
// echo '</pre>';

//================================================================================
// CONTINUE THE PAGE
//================================================================================

acf_form_head();
get_header();

// Will reset previous WP Query and clear all query vars!
wp_reset_query();
$wp_query = new WP_Query($query_args);

do_action( 'flatsome_before_page' ); ?>

<?php
// echo '<pre>';
// var_dump($showroom_category_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($showroom_tag_filter);
// echo '</pre>';

// echo '<pre>';
// var_dump($showroom_category_terms, $showroom_tag_terms);
// echo '</pre>';

// echo '<pre>';
// var_dump($query_args);
// echo '</pre>';

// echo '<pre>';
// var_dump($page_slug);
// echo '</pre>';

?>

<?php require_once __DIR__ . '/../includes/eruahaus/module-top-section.php'; ?>

<header class="entry-header" style="text-align: center; background-image: url('<?php echo content_url('/uploads'); ?>/2023/12/showroom-banner-pexels-suzy-hazelwood.jpg')">
    <h1 class="section-title"><span class="section-title-main"><?php _e('ShowRoom', 'erua'); ?></span></h1>
    <div class="banner-text"><p><?php _e('In our e-exhibition you will find stories and community content shared by our ERUAners', 'erua'); ?></p></div>
    <?php
    $user = wp_get_current_user();
    $eruahaus_eruaner_membership_request_page_id = ( get_field('eruahaus_eruaner_membership_request_page', 'option') ) ?? null;
    $eruahaus_showroom_presentation_creation_page_id = ( get_field('eruahaus_showroom_presentation_creation_page', 'option') ) ?? null;
    $allowed_roles = array('administrator', 'eruaner');
    if ( $user && array_intersect($allowed_roles, $user->roles ) ) :
    ?>
    <div class="banner-button-container"><a href="<?php echo get_permalink($eruahaus_showroom_presentation_creation_page_id); ?>" class="banner-button"><?php _e('Share your Story!', 'erua'); ?></a></div>
    <div class="banner-button-container"><a href="<?php echo get_permalink(2672); ?>" class="banner-button"><?php _e('See ShowRoom Events!', 'erua'); ?></a></div>
    <?php else: ?>
    <div class="banner-button-container"><a href="<?php echo get_permalink($eruahaus_eruaner_membership_request_page_id); ?>" class="banner-button"><?php _e('Become an ERUAner!', 'erua'); ?></a></div>
    <?php endif; ?>
</header>

<div id="content" class="content-area page-wrapper">

    <h2 style="font-size: 2rem; text-align: center; margin-top: 40px;"><?php _e('e-Exhibition', 'erua') ?></h2>

    <hr>

    <div id="debug" style="margin: 20px auto;"></div>

    <div style="display: flex; flex-direction: column; flex-wrap: wrap; margin-bottom: 60px;">
        <?php if ( ! $showroom_tag_terms ) : ?>
        <form id="showroom-search-form" action="" method="post">
            <div id="category-filters">
                <?php
                acf_form([
                    'form' => false,
                    'fields' => ['field_65602eff71acc'],
                ]);
                ?>
                <input type="hidden" name="_wp_http_referer" value="/showroom/" />
                <input type="hidden" name="_ajax_original_page_url" value="<?php echo esc_attr($page_url); ?>" />
                <input type="hidden" name="_ajax_original_page_slug" value="<?php echo esc_attr($page_slug); ?>" />
                <input type="hidden" name="_ajax_original_term_id" value="<?php echo esc_attr($current_term_id); ?>" />
                <input type="hidden" name="_ajax_taxonomy" value="<?php echo esc_attr($current_term_taxonomy_name); ?>" />
                <input type="hidden" name="_ajax_taxonomy_rewrite_slug" value="<?php echo esc_attr($current_term_taxonomy_name_rewrite_slug); ?>" />
                <!-- <button id="filter-presentations-button" class="button" name="conduct_presentations_search" style="left: 50%; transform: translatex(-50%); margin: 0;">Search</button> -->
                <input type="hidden" name="action" value="search_showroom_presentations" />
            </div>
        </form>
        <?php
        elseif ( $tag_term = get_term_by('id', $showroom_tag_terms[0], 'showroom-tag') ) :
            echo '<h4 class="text-center">' . __('Showing results for presentations tagged as', 'erua') . ' "' . $tag_term->name . '"' . '</h4>';
        endif;
        ?>
        <section class="presentations-section" class="col-inner" style="flex: 1;">
            <div id="ajax-loader" class="ajax-loader"><div></div><div></div><div></div></div>
            <div id="presentations-container">
                    <?php require_once __DIR__ . '/../includes/eruahaus/showroom/presentation-listings-content.php'; ?>
            </div>
        </section>
    </div>

    <hr>

</div>

<script>
jQuery(document).ready(function($) {

    <?php
    /*-------------------------------------------------------------------
        POPULATE FIELDS FROM QUERY URL FILTERS
    -------------------------------------------------------------------*/
    ?>
    <?php if ($showroom_category_filter) : ?>

    const categoryFilter = document.getElementById('search-by-showroom-category');
    const categoryFilterChoices = categoryFilter.querySelectorAll("input[type='radio']");
    let queryString1 = '<?php echo $showroom_category_filter; ?>';
    let queryArray1 = queryString1.split(',');
    categoryFilterChoices.forEach((input) => {
            if ( queryArray1.includes(input.value) ) {
                input.parentElement.classList.add('selected');
                input.setAttribute('checked', 'checked');
            }
            else {
                input.parentElement.classList.remove('selected');
                input.removeAttribute('checked');
            }
    });

    <?php
    endif;
    /**
     * Disable acf_form() navigate away warning.
     * https://support.advancedcustomfields.com/forums/topic/disable-acf_form-navigate-away-warning/
     */
    ?>
    jQuery(document).ready(function() {
        acf.unload.active = false;
    });

});
</script>

<?php
do_action( 'flatsome_after_page' );
get_footer();
