<?php
get_header();
?>

<?php require_once __DIR__ . '/includes/eruahaus/module-top-section.php'; ?>

<div id="content" class="blog-wrapper blog-single page-wrapper">

    <?php
        do_action('flatsome_before_blog');
    ?>

    <div class="row row-large <?php if(flatsome_option('blog_layout_divider')) echo 'row-divided ';?>">

        <div class="large-9 col">
        <?php
        if( is_single() ) {
            if ( have_posts() ) {

                /* Start the Loop */
                while ( have_posts() ) : the_post();
        ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="article-inner <?php flatsome_blog_article_classes(); ?>">
                        <header class="entry-header">
                            <div class="entry-header-text entry-header-text-top text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
                                <h6 class="entry-category is-xsmall">
                                    <?php echo get_the_category_list( __( ', ', 'flatsome' ) ) ?>
                                </h6>

                                <?php
                                $current_user_id = get_current_user_id();
                                $author_id = (int) get_the_author_meta( 'ID' );

                                $creative_blog_category = get_the_terms(get_the_ID(), 'creative-blog-category');
                                $creative_blog_tags = get_the_terms(get_the_ID(), 'creative-blog-tag');
                                $creative_blog_tag_taxonomy = get_taxonomy('creative-blog-tag');

                                if ( $creative_blog_category ) {
                                    echo '<h3 id="post-category">' . $creative_blog_category[0]->name . '</h3>';
                                }

                                if ( is_single() ) {
                                    echo '<h1 class="entry-title">' . get_the_title() . '</h1>';
                                } else {
                                    echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
                                }

                                if ( is_single() ) {
                                    if ( current_user_can('administrator') || $current_user_id === $author_id ) echo '<a class="post-edit-link" href="' . get_edit_post_link(get_the_ID()) . '">' . __('(Edit post)', 'erua') . '</a>';
                                }
                                ?>

                                <div class="entry-divider is-divider small"></div>

                                <?php
                                $single_post = is_singular( 'creative-blog-post' );
                                if ( $single_post && get_theme_mod( 'blog_single_header_meta', 1 ) ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php elseif ( ! $single_post && 'creative-blog-post' == get_post_type() ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if ( has_post_thumbnail() ) : ?>
                                <?php //if ( ! is_single() || ( is_single() && get_theme_mod( 'blog_single_featured_image', 1 ) ) ) : ?>
                                    <div class="entry-image relative">
                                        <?php //get_template_part( 'template-parts/posts/partials/entry-image', 'default' ); ?>
                                        <a href="<?php the_permalink();?>" style="display: flex; justify-content: center; margin-bottom: 20px; ">
                                            <?php the_post_thumbnail('large'); ?>
                                        </a>
                                        <?php //if ( get_theme_mod( 'blog_badge', 1 ) ) get_template_part( 'template-parts/posts/partials/entry', 'post-date' ); ?>
                                    </div>
                                <?php //endif; ?>
                            <?php endif; ?>
                            <?php
                            if ( $creative_blog_tags ) {
                                global $creative_blog_tag_taxonomy;
                                echo '<post-tags id="post-tags" style="display: flex; align-items: baseline; justify-content: end; margin-bottom: 10px;">';
                                echo '<span style="margin-right: 5px;">' .__('Tags:', 'erua') . '</span>';
                                if ( is_array($creative_blog_tags) ) {
                                    foreach ( $creative_blog_tags as $key => $tag ) {
                                        $separator = ( $key === array_key_last($creative_blog_tags) ) ? '' : ', ';
                                        
                                        echo '<span class="post-tag"><a href="' . site_url('/') . $creative_blog_tag_taxonomy->rewrite['slug'] . '/' . $tag->slug . '">'. $tag->name .'</a>' . $separator . '</span>';
                                    }
                                }
                                echo '</post-tags>';
                            }
                            ?>
                        </header>
                        <!-- <div>        
                            
                        </div> -->
                        <!-- <aside style="padding: 15px; margin-bottom: 30px; border: 1px solid #999;"> -->
                            <?php                            
                            //echo '<div><strong>Year</strong>: ' . get_the_date( 'Y' ) . '</div>';
                            ?>
                        <!-- </aside> -->
                        <?php get_template_part( 'template-parts/single', 'creative-blog-post' ); ?>
                    </div>
                </article>
        <?php
                endwhile;
            } else {
                get_template_part( 'no-results', 'index' );
            }
            //comments_template();
        }
        ?>
        </div>
        <div class="post-sidebar large-3 col">
            <?php flatsome_sticky_column_open( 'blog_sticky_sidebar' ); ?>
            <div id="secondary" class="widget-area <?php flatsome_sidebar_classes(); ?>" role="complementary">
                <?php do_action( 'before_sidebar' ); ?>
                <?php if ( ! dynamic_sidebar( 'eruahaus-creative-blog-sidebar' ) ) : ?>
                <?php endif; // end sidebar widget area ?>
            </div>
            <?php flatsome_sticky_column_close( 'blog_sticky_sidebar' ); ?>
        </div>
    </div>

    <?php
        do_action('flatsome_after_blog');
    ?>

</div>

<?php
get_footer();
