<?php
get_header();
?>

<?php require_once __DIR__ . '/includes/science-society/module-top-section.php'; ?>

<div id="content" class="blog-wrapper blog-single page-wrapper">

    <?php
        do_action('flatsome_before_blog');
    ?>

    <div class="row row-large <?php if(flatsome_option('blog_layout_divider')) echo 'row-divided ';?>">

        <div class="large-12 col">
        <?php
        if( is_single() ) {
            if ( have_posts() ) {

                /* Start the Loop */
                while ( have_posts() ) : the_post();
        ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="article-inner <?php flatsome_blog_article_classes(); ?>">
                        <header class="entry-header">
                            <div class="entry-header-text entry-header-text-top text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
                                <h6 class="entry-category is-xsmall">
                                    <?php echo get_the_category_list( __( ', ', 'flatsome' ) ) ?>
                                </h6>

                                <?php
                                $funding_opportunities_page_id = ( get_field('funding_opportunities_page', 'option') ) ?? null;
                                $funding_opportunities_page_url = ( $funding_opportunities_page_id ) ? get_permalink($funding_opportunities_page_id) : null;

                                $funding_opportunity_status = get_the_terms(get_the_ID(), 'funding-opportunity-status');
                                $funding_opportunity_publication_date = get_field('funding_opportunity_publication_date', get_the_ID());
                                $funding_opportunity_deadline = get_field('funding_opportunity_deadline', get_the_ID());
                                $funding_opportunity_website = get_field('funding_opportunity_website', get_the_ID());
                                $funding_opportunity_other_important_information = get_field('funding_opportunity_other_important_information', get_the_ID());
                                $funding_opportunity_subprogramme = get_field('funding_opportunity_subprogramme', get_the_ID());

                                $funding_opportunity_programme_taxonomy = get_taxonomy('funding-programme');
                                $funding_opportunity_scientific_field_taxonomy = get_taxonomy('funding-scientific-field');
                                $funding_opportunity_geographic_scope_taxonomy = get_taxonomy('funding-geographic-scope');
                                $funding_opportunity_topic_tags = get_taxonomy('funding-opportunity-topic');
                                $funding_opportunity_keyword_tags = get_taxonomy('funding-opportunity-keyword');

                                $funding_opportunity_programmes = get_the_terms(get_the_ID(), 'funding-programme');
                                $funding_opportunity_scientific_fields = get_the_terms(get_the_ID(), 'funding-scientific-field');
                                $funding_opportunity_geographic_scope = get_the_terms(get_the_ID(), 'funding-geographic-scope');
                                $funding_opportunity_topics = get_the_terms(get_the_ID(), 'funding-opportunity-topic');
                                $funding_opportunity_keywords = get_the_terms(get_the_ID(), 'funding-opportunity-keyword');

                                // if ( $funding_category ) {
                                //     echo '<h3 id="funding-category">' . $funding_category[0]->name . '</h3>';
                                // }

                                if ( is_single() ) {
                                    echo '<h1 class="entry-title">' . get_the_title() . '</h1>';
                                } else {
                                    echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
                                }

                                if ( is_single() ) {
                                    if ( current_user_can('administrator') ) echo '<a class="post-edit-link" href="' . get_edit_post_link(get_the_ID()) . '">' . __('(Edit Funding Opportunity)', 'erua') . '</a>';
                                }
                                ?>

                                <div class="entry-divider is-divider small"></div>

                                <?php
                                $single_funding = is_singular( 'funding-opportunity' );
                                if ( $single_funding && get_theme_mod( 'blog_single_header_meta', 1 ) ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php elseif ( ! $single_funding && 'funding-opportunity' == get_post_type() ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if ( has_post_thumbnail() ) : ?>
                                <?php //if ( ! is_single() || ( is_single() && get_theme_mod( 'blog_single_featured_image', 1 ) ) ) : ?>
                                    <div class="entry-image relative">
                                        <?php //get_template_part( 'template-parts/posts/partials/entry-image', 'default' ); ?>
                                        <a href="<?php the_permalink();?>" style="display: flex; justify-content: center; margin: 0 auto 20px auto; width: fit-content;">
                                            <?php the_post_thumbnail('large'); ?>
                                        </a>
                                        <?php //if ( get_theme_mod( 'blog_badge', 1 ) ) get_template_part( 'template-parts/posts/partials/entry', 'post-date' ); ?>
                                    </div>
                                <?php //endif; ?>
                            <?php endif; ?>
                        </header>
                        <div>
                            <div class="accordion alternate-style no-counter table-of-contents">
                                <div id="accordion-ps" class="accordion-item">
                                    <a id="accordion-ps-label" class="accordion-title plain plain" href="#accordion-item-project_sections" aria-expanded="false" aria-controls="accordion-ps-content"> <button class="toggle" aria-label="Toggle"><i class="icon-angle-down"></i></button> <span><?php _e('FUNDING OPPORTUNITY SECTIONS', 'erua'); ?></span> </a>
                                    <div id="accordion-ps-content" class="accordion-inner" style="display: none;" aria-labelledby="accordion-ps-label">

                                        <ul>
                                            <?php if ($funding_opportunity_status) : ?>
                                            <li><a href="#funding-status-info" class="toc-link"><?php _e('Funding Status', 'erua') ?></a></li>
                                            <?php endif; ?>
                                            <li><a href="#funding-description" class="toc-link">Description</a></li>
                                            <?php if ($funding_opportunity_programmes) : ?>
                                            <li><a href="#funding-programmes" class="toc-link">Funding Programmes</a></li>
                                            <?php endif; ?>
                                            <?php if ($funding_opportunity_geographic_scope) : ?>
                                            <li><a href="#funding-geographic-scope" class="toc-link">Geographic scope</a></li>
                                            <?php endif; ?>
                                            <?php if ($funding_opportunity_scientific_fields) : ?>
                                            <li><a href="#funding-scientific-fields" class="toc-link">Scientific Fields</a></li>
                                            <?php endif; ?>
                                            <?php if ($funding_opportunity_other_important_information) : ?>
                                            <li><a href="#funding-important-info" class="toc-link">Other important information</a></li>
                                            <?php endif; ?>
                                            <?php if ($funding_opportunity_topics) : ?>
                                            <li><a href="#funding-topics" class="toc-link">Topics</a></li>
                                            <?php endif; ?>
                                            <?php if ($funding_opportunity_keywords) : ?>
                                            <li><a href="#funding-keywords" class="toc-link">Keywords</a></li>
                                            <?php endif; ?>
                                        </ul>

                                    </div>
                                </div>
                            </div>
                            <?php
                            echo '<h2 id="funding-status-info">' .__('Funding Status', 'erua') . '</h2>';
                            if ( $funding_opportunity_status ) {
                                echo '<h3 id="funding-status"><span class="funding-status-name ' . $funding_opportunity_status[0]->slug . '">' . $funding_opportunity_status[0]->name . '</span></h3>';
                            }
                            if ( $funding_opportunity_publication_date ) {
                                echo '<h3 id="funding-publication">' . __('Publication date:', 'erua') . ' ' . '<span class="funding-publication-date">'. $funding_opportunity_deadline . '</span></h3>';
                            }
                            if ( $funding_opportunity_deadline ) {
                                echo '<h3 id="funding-deadline">' . __('Deadline:', 'erua') . ' ' . '<span class="funding-deadline-date">'. $funding_opportunity_deadline . '</span></h3>';
                            }
                            if ( $funding_opportunity_website ) {
                                echo '<h3>' .__('Webpage:', 'erua') . '</h3>';
                                echo '<p><a id="funding-website" href="' . $funding_opportunity_website . '" target="_blank" rel="nofollow">' . $funding_opportunity_website . '</a></p>';
                            }
                            ?>
                        </div>
                        <!-- <aside style="padding: 15px; margin-bottom: 30px; border: 1px solid #999;"> -->
                            <?php                            
                            //echo '<div><strong>Year</strong>: ' . get_the_date( 'Y' ) . '</div>';
                            ?>
                        <!-- </aside> -->
                        <?php get_template_part( 'template-parts/single', 'funding-opportunity' ); ?>
                    </div>
                </article>
        <?php
                endwhile;
            } else {
                get_template_part( 'no-results', 'index' );
            }
            //comments_template();
        }
        ?>
        </div>
        <!-- <div class="post-sidebar large-3 col">
            <?php //flatsome_sticky_column_open( 'blog_sticky_sidebar' ); ?>
            <div id="secondary" class="widget-area <?php //flatsome_sidebar_classes(); ?>" role="complementary">
                <?php //do_action( 'before_sidebar' ); ?>
                <?php //if ( ! dynamic_sidebar( 'funding-opportunities-sidebar' ) ) : ?>
                <?php //endif; // end sidebar widget area ?>
            </div>
            <?php //flatsome_sticky_column_close( 'blog_sticky_sidebar' ); ?>
        </div> -->
    </div>

    <?php
        do_action('flatsome_after_blog');
    ?>

</div>

<?php
get_footer();
