<?php
/**
 * Block Name: Hackathon Challenges
 *
 * This is the template that displays the Hackathon Challenges block.
 */

// create id attribute for specific styling
$id = 'hackathon-challenges-' . $block['id'];

// create align class ("alignwide") from block setting ("wide")
$align_class = $block['align'] ? 'align' . $block['align'] : '';

// $classes = ['block-challenges'];
// if( !empty( $block['className'] ) )
//     $classes = array_merge( $classes, explode( ' ', $block['className'] ) );

// $anchor = '';
// if( !empty( $block['anchor'] ) )
//     $anchor = ' id="' . sanitize_title( $block['anchor'] ) . '"';

// https://wordpress.stackexchange.com/questions/347021/how-can-i-access-core-paragraph-textcolor-in-a-block-template
$template = array(
    array('core/heading', array(
        'level' => 2,
        'content' => 'Challenges',
        'textAlign' => 'center',
    )),
    array( 'core/paragraph', array(
        'content' => "Challenges Information.",
    ) )
);
?>
<div id="<?php echo $id; ?>" class="hackathon-challenges <?php echo $align_class; ?>">
    <div id="hackathon-challenges"><?php echo '<InnerBlocks template="' . esc_attr( wp_json_encode( $template ) ) . '" />'; ?></div>
</div>
<style type="text/css">
    #<?php echo $id; ?> {
        background: <?php the_field('hackathon_challenges_background_color'); ?>;
        color: <?php the_field('hackathon_challenges_text_color'); ?>;
    }
</style>