<?php
/**
 * Block Name: Hackathon Steps
 *
 * This is the template that displays the Hackathon Steps block.
 */

// create id attribute for specific styling
$id = 'hackathon-steps-' . $block['id'];

// create align class ("alignwide") from block setting ("wide")
$align_class = $block['align'] ? 'align' . $block['align'] : '';

$rows = get_field('hackathon_steps');
?>
<?php if ( $rows ) : $counter = 0; ?>
<div id="<?php echo $id; ?>" class="hackathon-steps <?php echo $align_class; ?>">
    <h2 id="hackathon-steps" class="hackathon-steps-title"><?php _e('Steps', 'erua'); ?></h2>
    <div class="hackathon-step-container">
    <?php foreach( $rows as $row ) : $counter++ ?>

        <div class="hackathon-step">
            <span class="step-number"><?php echo $counter; ?>.</span><h3 class="step-heading"><?php echo $row['hackathon_step_heading']; ?></h3><h3 class="step-instruction"><?php echo $row['hackathon_step_instruction']; ?></h3>
        </div>

    <?php endforeach; ?>
    </div>
</div>
<?php else: ?>
<p><?php _e('Hackathon Steps', 'erua'); ?></p>
<?php endif; ?>
<style type="text/css">
    #<?php echo $id; ?> {
        background: <?php the_field('steps_background_color'); ?>;
        color: <?php the_field('steps_text_color'); ?>;
    }
</style>