<div class="entry-content single-page">
    <h2 id="funding-description"><?php _e('Description', 'erua'); ?></h2>

    <?php the_content(); ?>

    <?php
    global $funding_opportunity_programmes, $funding_opportunity_subprogramme, $funding_opportunity_geographic_scope, $funding_opportunity_scientific_fields, $funding_opportunity_topics, $funding_opportunity_keywords, $funding_opportunity_other_important_information, $funding_opportunities_page_url;

    if ( $funding_opportunity_programmes ) {
        //global $funding_opportunity_programme_taxonomy;
        echo '<funding-programmes id="funding-programmes" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Funding Programmes', 'erua') . '</h2>';
        echo '<p>';
        if ( is_array($funding_opportunity_programmes) ) {
            foreach ( $funding_opportunity_programmes as $key => $programme ) {
                $separator = ( $key === array_key_last($funding_opportunity_programmes) ) ? '' : ', ';
    
                if ( $funding_opportunities_page_url ) {
                    echo '<span class="funding-programme"><a href="' . $funding_opportunities_page_url . '?funding_programmes='.$programme->term_id.'">'. $programme->name .'</a>' . $separator . '</span>';
                }
                else {
                    //echo '<span class="funding-programme"><a href="' . site_url('/') . $funding_opportunity_programme_taxonomy->rewrite['slug'] . '/' . $programme->slug . '">'. $programme->name .'</a>' . $separator . '</span>';
                    echo '<span class="funding-programme">' . $programme->name . $separator . '</span>';
                }
            }
        }
        echo '</p>';
        if ( $funding_opportunity_subprogramme ) {
            echo '<h3 id="funding-subprogramme">' . __('Subprogramme:', 'erua') . ' ' . $funding_opportunity_subprogramme . '</h3>';
        }
        echo '</funding-programmes>';
    }

    if ( $funding_opportunity_geographic_scope ) {
        echo '<h2 id="funding-geographic-scope">' .__('Geographic scope', 'erua') . '</h2>';
        if ( $funding_opportunities_page_url ) {
            echo '<p><a href="'.$funding_opportunities_page_url.'?funding_gs='.$funding_opportunity_geographic_scope[0]->term_id.'">' . $funding_opportunity_geographic_scope[0]->name . '</a></p>';
        }
        else {
            echo '<p>' . $funding_opportunity_geographic_scope[0]->name . '</p>';
        }  
    }

    if ( $funding_opportunity_scientific_fields ) {
        //global $funding_opportunity_scientific_field_taxonomy;
        echo '<funding-fields id="funding-scientific-fields" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Scientific Fields', 'erua') . '</h2>';
        if ( is_array($funding_opportunity_scientific_fields) ) {
            foreach ( $funding_opportunity_scientific_fields as $key => $field ) {
                $separator = ( $key === array_key_last($funding_opportunity_scientific_fields) ) ? '' : ', ';
    
                if ( $funding_opportunities_page_url ) {
                    echo '<span class="funding-scientific-field"><a href="' . $funding_opportunities_page_url . '?funding_sf='.$field->term_id.'">'. $field->name .'</a>' . $separator . '</span>';
                }
                else {
                    //echo '<span class="funding-scientific-field"><a href="' . site_url('/') . $funding_opportunity_scientific_field_taxonomy->rewrite['slug'] . '/' . $field->slug . '">'. $field->name .'</a>' . $separator . '</span>';
                    echo '<span class="funding-scientific-field">' . $field->name . '</a>' . $separator . '</span>';
                }
            }
        }
        echo '</funding-fields>';
    }

    if ( $funding_opportunity_other_important_information ) {
        echo '<h2 id="funding-important-info">' .__('Other important information', 'erua') . '</h2>';
        echo '<p>' . $funding_opportunity_other_important_information . '</p>';
    }

    if ( $funding_opportunity_topics ) {
        //global $funding_opportunity_topic_tags;
        echo '<topics id="funding-topics" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Topics', 'erua') . '</h2>';
        if ( is_array($funding_opportunity_topics) ) {
            foreach ( $funding_opportunity_topics as $key => $topic ) {
                $separator = ( $key === array_key_last($funding_opportunity_topics) ) ? '' : ', ';
    
                if ( $funding_opportunities_page_url ) {
                    echo '<span class="funding-topic funding-tag"><a href="' . $funding_opportunities_page_url . '?topic_tag='.$topic->term_id.'">'. $topic->name .'</a>' . $separator . '</span>';
                }
                else {
                    //echo '<span class="funding-topic funding-tag"><a href="' . site_url('/') . $funding_opportunity_topic_tags->rewrite['slug'] . '/' . $topic->slug . '">'. $topic->name .'</a>' . $separator . '</span>';
                    echo '<span class="funding-topic funding-tag">' . $topic->name . $separator . '</span>';
                }
            }
        }
        echo '</topics>';
    }

    if ( $funding_opportunity_keywords ) {
        //global $funding_opportunity_keyword_tags;
        echo '<keywords id="funding-keywords" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Keywords', 'erua') . '</h2>';
        if ( is_array($funding_opportunity_keywords) ) {
            foreach ( $funding_opportunity_keywords as $key => $keyword ) {
                $separator = ( $key === array_key_last($funding_opportunity_keywords) ) ? '' : ', ';
    
                if ( $funding_opportunities_page_url ) {
                    echo '<span class="funding-keyword funding-tag"><a href="' . $funding_opportunities_page_url . '?keyword_tag='.$keyword->term_id.'">'. $keyword->name .'</a>' . $separator . '</span>';
                }
                else {
                    //echo '<span class="funding-keyword funding-tag"><a href="' . site_url('/') . $funding_opportunity_keyword_tags->rewrite['slug'] . '/' . $keyword->slug . '">'. $keyword->name .'</a>' . $separator . '</span>';
                    echo '<span class="funding-keyword funding-tag">' . $keyword->name . $separator . '</span>';
                }
            }
        }
        echo '</keywords>';
    }
    ?>

    <?php
    wp_link_pages();
    ?>

    <?php if ( get_theme_mod( 'blog_share', 1 ) ) {
        // SHARE ICONS
        echo '<div class="blog-share text-center">';
        echo '<div class="is-divider medium"></div>';
        echo do_shortcode( '[share]' );
        echo '</div>';
    } ?>
</div>

<?php if ( get_theme_mod( 'blog_single_footer_meta', 1 ) ) : ?>
    <footer class="entry-meta text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
        <?php
        /* translators: used between list items, there is a space after the comma */
        $category_list = get_the_category_list( __( ', ', 'flatsome' ) );

        /* translators: used between list items, there is a space after the comma */
        $tag_list = get_the_tag_list( '', __( ', ', 'flatsome' ) );


        // But this blog has loads of categories so we should probably display them here.
        if ( '' != $tag_list ) {
            $meta_text = __( 'This entry was posted in %1$s and tagged %2$s.', 'flatsome' );
        } else {
            $meta_text = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'flatsome' );
        }

        printf( $meta_text, $category_list, $tag_list, get_permalink(), the_title_attribute( 'echo=0' ) );
        ?>
    </footer>
<?php endif; ?>

<?php if ( get_theme_mod( 'blog_author_box', 1 ) ) : ?>
    <div class="entry-author author-box">
        <div class="flex-row align-top">
            <div class="flex-col mr circle">
                <div class="blog-author-image">
                    <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'flatsome_author_bio_avatar_size', 90 ) ); ?>
                </div>
            </div>
            <div class="flex-col flex-grow">
                <h5 class="author-name uppercase pt-half">
                    <?php the_author_meta( 'display_name' ); ?>
                </h5>
                <p class="author-desc small"><?php the_author_meta( 'description' ); ?></p>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if ( get_theme_mod( 'blog_single_next_prev_nav', 1 ) ) :
    flatsome_content_nav( 'nav-below' );
endif; ?>
